/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.util.abstractjar.impl;

import com.yworks.util.abstractjar.Entry;
import com.yworks.util.abstractjar.StreamProvider;
import com.yworks.util.abstractjar.impl.JarEntryWrapper;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarStreamProvider
implements StreamProvider {
    private JarFile f;
    private Enumeration<? extends JarEntry> en;
    JarEntry currentEntry;
    private String currentEntryName;
    private String currentDir;
    private String currentFilename;

    public JarStreamProvider(File jarFile) throws IOException {
        if (!jarFile.exists()) {
            throw new IllegalArgumentException("jar file not found: " + jarFile.toString());
        }
        this.f = new JarFile(jarFile);
        this.en = this.f.entries();
    }

    @Override
    public void reset() {
        this.en = this.f.entries();
    }

    @Override
    public DataInputStream getNextClassEntryStream() throws IOException {
        ZipEntry entry = null;
        while (this.en.hasMoreElements() && !(entry = this.en.nextElement()).getName().endsWith(".class")) {
        }
        if (entry != null && entry.getName().endsWith(".class")) {
            this.setCurrentEntry((JarEntry)entry);
            return new DataInputStream(new BufferedInputStream(this.f.getInputStream(entry)));
        }
        this.setCurrentEntry(null);
        return null;
    }

    @Override
    public DataInputStream getNextResourceEntryStream() throws IOException {
        ZipEntry entry = null;
        while (this.en.hasMoreElements() && ((entry = this.en.nextElement()).getName().endsWith(".class") || entry.isDirectory())) {
        }
        if (entry != null && !entry.getName().endsWith(".class") && !entry.isDirectory()) {
            this.setCurrentEntry((JarEntry)entry);
            return new DataInputStream(new BufferedInputStream(this.f.getInputStream(entry)));
        }
        this.setCurrentEntry(null);
        return null;
    }

    @Override
    public Entry getCurrentEntry() {
        return new JarEntryWrapper(this.currentEntry);
    }

    @Override
    public String getCurrentEntryName() {
        return this.currentEntryName;
    }

    @Override
    public String getCurrentDir() {
        return this.currentDir;
    }

    @Override
    public String getCurrentFilename() {
        return this.currentFilename;
    }

    private void setCurrentEntry(JarEntry entry) {
        if (null != entry) {
            this.currentEntry = entry;
            this.currentEntryName = this.currentEntry.getName();
            File entryFile = new File(this.currentEntryName);
            this.currentDir = entryFile.getParent() != null ? entryFile.getParent() : "";
            this.currentFilename = entryFile.getName();
        } else {
            this.currentEntry = null;
            this.currentDir = null;
            this.currentFilename = null;
        }
    }
}

