/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.util.abstractjar.impl;

import com.yworks.util.abstractjar.Entry;
import com.yworks.util.abstractjar.StreamProvider;
import com.yworks.util.abstractjar.impl.FileEntryWrapper;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DirectoryStreamProvider
extends SimpleFileVisitor<Path>
implements StreamProvider {
    private File directory;
    private List<Entry> entries = new ArrayList<Entry>();
    private Iterator<Entry> entryIterator;
    private Entry currentEntry;

    public DirectoryStreamProvider(File directory) throws IOException {
        this.directory = directory;
        Files.walkFileTree(directory.toPath(), this);
        this.entryIterator = this.entries.iterator();
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
        if (attrs.isRegularFile()) {
            this.entries.add(new FileEntryWrapper(path.toFile(), this.directory.toPath().relativize(path).toString()));
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public DataInputStream getNextClassEntryStream() throws IOException {
        FileEntryWrapper entry = null;
        while (this.entryIterator.hasNext() && !(entry = (FileEntryWrapper)this.entryIterator.next()).getName().endsWith(".class")) {
        }
        if (entry != null && entry.getName().endsWith(".class")) {
            this.currentEntry = entry;
            return new DataInputStream(new BufferedInputStream(new FileInputStream(entry.getFile())));
        }
        this.currentEntry = null;
        return null;
    }

    @Override
    public DataInputStream getNextResourceEntryStream() throws IOException {
        FileEntryWrapper entry = null;
        while (this.entryIterator.hasNext() && (entry = (FileEntryWrapper)this.entryIterator.next()).getName().endsWith(".class")) {
        }
        if (entry != null && !entry.getName().endsWith(".class") && !entry.isDirectory()) {
            this.currentEntry = entry;
            return new DataInputStream(new BufferedInputStream(new FileInputStream(entry.getFile())));
        }
        this.currentEntry = null;
        return null;
    }

    @Override
    public Entry getCurrentEntry() {
        return this.currentEntry;
    }

    @Override
    public String getCurrentEntryName() {
        if (this.currentEntry != null) {
            FileEntryWrapper entryWrapper = (FileEntryWrapper)this.currentEntry;
            return this.directory.toPath().relativize(entryWrapper.getFile().toPath()).toString().replace("\\", "/");
        }
        return null;
    }

    @Override
    public String getCurrentDir() {
        if (this.currentEntry != null) {
            FileEntryWrapper entryWrapper = (FileEntryWrapper)this.currentEntry;
            return this.directory.toPath().relativize(entryWrapper.getFile().toPath().getParent()).toString();
        }
        return null;
    }

    @Override
    public String getCurrentFilename() {
        return this.currentEntry != null ? this.currentEntry.getName() : null;
    }

    @Override
    public void reset() {
        this.entryIterator = this.entries.iterator();
    }
}

