/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.setting.dialect;

import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.log.StaticLog;
import com.xiaoleilu.hutool.setting.AbsSetting;
import com.xiaoleilu.hutool.setting.SettingLoader;
import com.xiaoleilu.hutool.setting.SettingRuntimeException;
import com.xiaoleilu.hutool.util.CharsetUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import com.xiaoleilu.hutool.util.URLUtil;
import com.xiaoleilu.hutool.watch.SimpleWatcher;
import com.xiaoleilu.hutool.watch.WatchMonitor;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BasicSetting
extends AbsSetting
implements Map<Object, Object> {
    public static final Charset DEFAULT_CHARSET = CharsetUtil.CHARSET_UTF_8;
    private final LinkedList<String> groups = new LinkedList();
    private final Map<Object, Object> map = new ConcurrentHashMap<Object, Object>();
    protected Charset charset;
    protected boolean isUseVariable;
    protected URL settingUrl;
    private SettingLoader settingLoader;
    private WatchMonitor watchMonitor;

    public BasicSetting() {
    }

    public BasicSetting(String pathBaseClassLoader, Charset charset, boolean isUseVariable) {
        URL url;
        if (null == pathBaseClassLoader) {
            pathBaseClassLoader = "";
        }
        if ((url = URLUtil.getURL(pathBaseClassLoader)) == null) {
            throw new RuntimeException(StrUtil.format("Can not find Setting file: [{}]", pathBaseClassLoader));
        }
        this.init(url, charset, isUseVariable);
    }

    public BasicSetting(String pathBaseClassLoader) {
        this(pathBaseClassLoader, DEFAULT_CHARSET, false);
    }

    public BasicSetting(File configFile, Charset charset, boolean isUseVariable) {
        if (configFile == null) {
            throw new NullPointerException("Null Setting file!");
        }
        URL url = URLUtil.getURL(configFile);
        if (url == null) {
            throw new RuntimeException(StrUtil.format("Can not find Setting file: [{}]", configFile.getAbsolutePath()));
        }
        this.init(url, charset, isUseVariable);
    }

    public BasicSetting(String path, Class<?> clazz, Charset charset, boolean isUseVariable) {
        URL url = URLUtil.getURL(path, clazz);
        if (url == null) {
            throw new RuntimeException(StrUtil.format("Can not find Setting file: [{}]", path));
        }
        this.init(url, charset, isUseVariable);
    }

    public BasicSetting(URL url, Charset charset, boolean isUseVariable) {
        if (url == null) {
            throw new RuntimeException("Null url define!");
        }
        this.init(url, charset, isUseVariable);
    }

    public boolean init(URL settingUrl, Charset charset, boolean isUseVariable) {
        if (settingUrl == null) {
            throw new RuntimeException("Null setting url or charset define!");
        }
        this.settingUrl = settingUrl;
        this.charset = charset;
        this.isUseVariable = isUseVariable;
        return this.load();
    }

    public synchronized boolean load() {
        if (null == this.settingLoader) {
            this.settingLoader = new SettingLoader(this, this.charset, this.isUseVariable);
        }
        return this.settingLoader.load(this.settingUrl);
    }

    public void autoLoad(boolean autoReload) {
        if (autoReload) {
            if (null != this.watchMonitor) {
                this.watchMonitor.close();
            }
            try {
                this.watchMonitor = WatchMonitor.create(this.settingUrl, StandardWatchEventKinds.ENTRY_MODIFY);
                this.watchMonitor.setWatcher(new SimpleWatcher(){

                    @Override
                    public void onModify(WatchEvent<?> event) {
                        BasicSetting.this.load();
                    }
                }).start();
            }
            catch (Exception e) {
                throw new SettingRuntimeException(e, "Setting auto load not support url: [{}]", this.settingUrl);
            }
            StaticLog.debug("Auto load for [{}] listenning...", this.settingUrl);
        } else {
            IoUtil.close(this.watchMonitor);
            this.watchMonitor = null;
        }
    }

    public String getSettingPath() {
        return this.settingUrl.getPath();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Object getObj(String key, Object defaultValue) {
        Object value = this.map.get(key);
        if (null == value) {
            return defaultValue;
        }
        return value;
    }

    public Map<?, ?> getMap(String group) {
        if (StrUtil.isBlank(group)) {
            return this;
        }
        String groupDot = group.concat(".");
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        for (Object key : this.map.keySet()) {
            String keyStr = Convert.toStr(key);
            if (!StrUtil.isNotBlank(keyStr) || !keyStr.startsWith(groupDot)) continue;
            map2.put(StrUtil.removePrefix(keyStr, groupDot), this.map.get(key));
        }
        return map2;
    }

    public BasicSetting getSetting(String group) {
        BasicSetting setting = new BasicSetting();
        setting.putAll((Map<? extends Object, ? extends Object>)this.getMap(group));
        return setting;
    }

    public Properties getProperties(String group) {
        Properties properties = new Properties();
        properties.putAll(this.getMap(group));
        return properties;
    }

    public void store(String absolutePath) {
        if (null == this.settingLoader) {
            this.settingLoader = new SettingLoader(this, this.charset, this.isUseVariable);
        }
        this.settingLoader.store(absolutePath);
    }

    public void setVarRegex(String regex) {
        if (null == this.settingLoader) {
            throw new NullPointerException("SettingLoader is null !");
        }
        this.settingLoader.setVarRegex(regex);
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.putAll(this.map);
        return properties;
    }

    public LinkedList<String> getGroups() {
        return this.groups;
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Object put(Object key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> map) {
        this.map.putAll(map);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<Object> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    public String toString() {
        return this.map.toString();
    }
}

