/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.setting;

import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.getter.OptNullBasicTypeFromObjectGetter;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.StaticLog;
import com.xiaoleilu.hutool.util.BeanUtil;
import com.xiaoleilu.hutool.util.StrUtil;

public abstract class AbsSetting
extends OptNullBasicTypeFromObjectGetter<String> {
    private static final Log log = StaticLog.get();
    public static final String DEFAULT_DELIMITER = ",";

    @Override
    public abstract Object getObj(String var1, Object var2);

    public String getStr(String key, String group, String defaultValue) {
        String value = this.getByGroup(key, group);
        if (StrUtil.isBlank(value)) {
            return defaultValue;
        }
        return value;
    }

    public String getByGroup(String key, String group) {
        return this.getStr(AbsSetting.keyWithGroup(key, group));
    }

    public String getWithLog(String key) {
        String value = this.getStr(key);
        if (value == null) {
            log.debug("No key define for [{}]!", key);
        }
        return value;
    }

    public String getByGroupWithLog(String key, String group) {
        String value = this.getByGroup(key, group);
        if (value == null) {
            log.debug("No key define for [{}] of group [{}] !", key, group);
        }
        return value;
    }

    public String[] getStrings(String key) {
        return this.getStrings(key, null);
    }

    public String[] getStringsWithDefault(String key, String[] defaultValue) {
        String[] value = this.getStrings(key, null);
        if (null == value) {
            value = defaultValue;
        }
        return value;
    }

    public String[] getStrings(String key, String group) {
        return this.getStrings(key, group, DEFAULT_DELIMITER);
    }

    public String[] getStrings(String key, String group, String delimiter) {
        String value = this.getByGroup(key, group);
        if (StrUtil.isBlank(value)) {
            return null;
        }
        return StrUtil.split(value, delimiter);
    }

    public Integer getInt(String key, String group) {
        return this.getInt(key, group, null);
    }

    public Integer getInt(String key, String group, Integer defaultValue) {
        return Convert.toInt(this.getByGroup(key, group), defaultValue);
    }

    public Boolean getBool(String key, String group) {
        return this.getBool(key, group, null);
    }

    public Boolean getBool(String key, String group, Boolean defaultValue) {
        return Convert.toBool(this.getByGroup(key, group), defaultValue);
    }

    public Long getLong(String key, String group) {
        return this.getLong(key, group, null);
    }

    public Long getLong(String key, String group, Long defaultValue) {
        return Convert.toLong(this.getByGroup(key, group), defaultValue);
    }

    public Character getChar(String key, String group) {
        String value = this.getByGroup(key, group);
        if (StrUtil.isBlank(value)) {
            return null;
        }
        return Character.valueOf(value.charAt(0));
    }

    public Double getDouble(String key, String group) {
        return this.getDouble(key, group, null);
    }

    public Double getDouble(String key, String group, Double defaultValue) {
        return Convert.toDouble(this.getByGroup(key, group), defaultValue);
    }

    public Object toBean(final String group, Object bean) {
        return BeanUtil.fillBean(bean, new BeanUtil.ValueProvider(){

            @Override
            public Object value(String name) {
                String value = AbsSetting.this.getByGroup(name, group);
                if (null != value) {
                    log.debug("Parse setting to object field [{}={}]", name, value);
                }
                return value;
            }

            @Override
            public boolean isIgnoreError() {
                return false;
            }
        });
    }

    public Object toBean(Object bean) {
        return this.toBean(null, bean);
    }

    private static String keyWithGroup(String key, String group) {
        String keyWithGroup = key;
        if (!StrUtil.isBlank(group)) {
            keyWithGroup = group.concat(".").concat(key);
        }
        return keyWithGroup;
    }
}

