/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.log.dialect.log4j2;

import com.xiaoleilu.hutool.log.AbstractLocationAwareLog;
import com.xiaoleilu.hutool.util.StrUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.AbstractLogger;

public class Log4j2Log
extends AbstractLocationAwareLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String FQCN = Log4j2Log.class.getName();
    private final transient Logger logger;

    public Log4j2Log(Logger logger) {
        this.logger = logger;
    }

    public Log4j2Log(Class<?> clazz) {
        this(LogManager.getLogger(clazz));
    }

    public Log4j2Log(String name) {
        this(LogManager.getLogger((String)name));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.trace(null, format, arguments);
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.TRACE, t, format, arguments)) {
            this.logger.trace(StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.debug(null, format, arguments);
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.DEBUG, t, format, arguments)) {
            this.logger.debug(StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.info(null, format, arguments);
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.INFO, t, format, arguments)) {
            this.logger.info(StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.warn(null, format, arguments);
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.WARN, t, format, arguments)) {
            this.logger.warn(StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.error(null, format, arguments);
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        if (!this.logIfEnabled(Level.ERROR, t, format, arguments)) {
            this.logger.warn(StrUtil.format(format, arguments), t);
        }
    }

    @Override
    public void log(com.xiaoleilu.hutool.log.level.Level level, String format, Object ... arguments) {
        this.log(level, null, format, arguments);
    }

    @Override
    public void log(com.xiaoleilu.hutool.log.level.Level level, Throwable t, String format, Object ... arguments) {
        this.log(FQCN, level, t, format, arguments);
    }

    @Override
    public void log(String fqcn, com.xiaoleilu.hutool.log.level.Level level, Throwable t, String format, Object ... arguments) {
        Level log4j2Level;
        switch (level) {
            case TRACE: {
                log4j2Level = Level.TRACE;
                break;
            }
            case DEBUG: {
                log4j2Level = Level.DEBUG;
                break;
            }
            case INFO: {
                log4j2Level = Level.INFO;
                break;
            }
            case WARN: {
                log4j2Level = Level.WARN;
                break;
            }
            case ERROR: {
                log4j2Level = Level.ERROR;
                break;
            }
            default: {
                throw new Error(StrUtil.format("Can not identify level: {}", new Object[]{level}));
            }
        }
        this.logIfEnabled(fqcn, log4j2Level, t, format, arguments);
    }

    private boolean logIfEnabled(Level level, Throwable t, String msgTemplate, Object ... arguments) {
        return this.logIfEnabled(FQCN, level, t, msgTemplate, arguments);
    }

    private boolean logIfEnabled(String fqcn, Level level, Throwable t, String msgTemplate, Object ... arguments) {
        if (this.logger instanceof AbstractLogger) {
            ((AbstractLogger)this.logger).logIfEnabled(fqcn, level, null, StrUtil.format(msgTemplate, arguments), t);
            return true;
        }
        return false;
    }
}

