/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds.tomcat;

import com.xiaoleilu.hutool.db.DbRuntimeException;
import com.xiaoleilu.hutool.db.ds.DSFactory;
import com.xiaoleilu.hutool.setting.Setting;
import com.xiaoleilu.hutool.util.CollectionUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;

public class TomcatDSFactory
extends DSFactory {
    private Setting setting;
    private Map<String, DataSource> dsMap;

    public TomcatDSFactory() {
        this((Setting)null);
    }

    public TomcatDSFactory(Setting setting) {
        super("Tomcat-Jdbc-Pool");
        this.checkCPExist(DataSource.class);
        if (null == setting) {
            setting = new Setting("config/db.setting", true);
        }
        this.setting = setting;
        this.dsMap = new ConcurrentHashMap<String, DataSource>();
    }

    public DataSource getDataSource(String group) {
        DataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        DataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        DataSource ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            ds.close();
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionUtil.isNotEmpty(this.dsMap)) {
            Collection<DataSource> values = this.dsMap.values();
            for (DataSource ds : values) {
                if (null == ds) continue;
                ds.close();
            }
            this.dsMap.clear();
            this.dsMap = null;
        }
    }

    private DataSource createDataSource(String group) {
        Setting config;
        if (group == null) {
            group = "";
        }
        if (null == (config = this.setting.getSetting(group)) || config.isEmpty()) {
            throw new DbRuntimeException("No Tomcat jdbc pool config for group: [{}]", group);
        }
        PoolProperties poolProps = new PoolProperties();
        config.toBean(poolProps);
        DataSource ds = new DataSource();
        ds.setPoolProperties((PoolConfiguration)poolProps);
        return ds;
    }
}

