/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.db.DbRuntimeException;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.lang.Dict;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.ClassUtil;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Entity
extends Dict {
    private static final long serialVersionUID = -1951012511464327448L;
    private String tableName;
    private Set<String> fieldNames;

    public static Entity create() {
        return new Entity();
    }

    public static Entity create(String tableName) {
        return new Entity(tableName);
    }

    public static <T> Entity parse(T bean) {
        return Entity.create(null).parseBean((Object)bean);
    }

    public Entity() {
    }

    public Entity(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Entity setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Set<String> getFieldNames() {
        return this.fieldNames;
    }

    public Entity setFieldNames(List<String> fieldNames) {
        if (CollectionUtil.isNotEmpty(fieldNames)) {
            this.fieldNames = new HashSet<String>(fieldNames);
        }
        return this;
    }

    public Entity setFieldNames(String ... fieldNames) {
        if (ArrayUtil.isNotEmpty(fieldNames)) {
            this.fieldNames = CollectionUtil.newHashSet(fieldNames);
        }
        return this;
    }

    public Entity addFieldNames(String ... fieldNames) {
        if (ArrayUtil.isNotEmpty(fieldNames)) {
            if (null == this.fieldNames) {
                return this.setFieldNames(fieldNames);
            }
            for (String fieldName : fieldNames) {
                this.fieldNames.add(fieldName);
            }
        }
        return this;
    }

    @Override
    public <T> Entity parseBean(T bean) {
        String tableName = bean.getClass().getSimpleName();
        tableName = StrUtil.lowerFirst(tableName);
        this.setTableName(tableName);
        return (Entity)super.parseBean(bean);
    }

    @Override
    public Object put(String key, Object value) {
        if (CollectionUtil.isEmpty(this.fieldNames) || this.fieldNames.contains(key)) {
            super.put(key, value);
        }
        return null;
    }

    @Override
    public Entity set(String field, Object value) {
        return (Entity)super.set(field, value);
    }

    @Override
    public Entity setIgnoreNull(String field, Object value) {
        return (Entity)super.setIgnoreNull(field, value);
    }

    public Clob getClob(String field) {
        return this.get(field, null);
    }

    @Override
    public Time getTime(String field) {
        Object obj = this.get(field);
        Time result = null;
        if (null != obj) {
            try {
                result = (Time)obj;
            }
            catch (Exception e) {
                result = (Time)ClassUtil.invoke(obj, "timeValue", new Object[0]);
            }
        }
        return result;
    }

    @Override
    public Date getDate(String field) {
        Object obj = this.get(field);
        Date result = null;
        if (null != obj) {
            try {
                result = (Date)obj;
            }
            catch (Exception e) {
                result = (Date)ClassUtil.invoke(obj, "dateValue", new Object[0]);
            }
        }
        return result;
    }

    @Override
    public Timestamp getTimestamp(String field) {
        Object obj = this.get(field);
        Timestamp result = null;
        if (null != obj) {
            try {
                result = (Timestamp)obj;
            }
            catch (Exception e) {
                result = (Timestamp)ClassUtil.invoke(obj, "timestampValue", new Object[0]);
            }
        }
        return result;
    }

    @Override
    public String getStr(String field) {
        Object obj = this.get(field);
        if (obj instanceof Clob) {
            Clob clob = (Clob)obj;
            Reader reader = null;
            try {
                reader = clob.getCharacterStream();
                String string = IoUtil.read(reader);
                return string;
            }
            catch (IOException | SQLException e) {
                throw new DbRuntimeException(e);
            }
            finally {
                IoUtil.close(reader);
            }
        }
        if (obj instanceof RowId) {
            RowId rowId = (RowId)obj;
            return StrUtil.str(rowId.getBytes(), "UTF-8");
        }
        return super.getStr(field);
    }

    public RowId getRowId() {
        return this.getRowId("ROWID");
    }

    public RowId getRowId(String field) {
        Object obj = this.get(field);
        if (null == obj) {
            return null;
        }
        if (obj instanceof RowId) {
            return (RowId)obj;
        }
        throw new DbRuntimeException("Value of field [{}] is not a rowid!", field);
    }

    @Override
    public Entity clone() {
        return (Entity)super.clone();
    }

    @Override
    public String toString() {
        return "Entity {tableName=" + this.tableName + ", fieldNames=" + this.fieldNames + ", fields=" + super.toString() + "}";
    }
}

