/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.convert.impl;

import com.xiaoleilu.hutool.convert.AbstractConverter;
import com.xiaoleilu.hutool.util.StrUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;

public class NumberConverter
extends AbstractConverter<Number> {
    private Class<? extends Number> targetType;

    public NumberConverter() {
        this.targetType = Number.class;
    }

    public NumberConverter(Class<? extends Number> clazz) {
        this.targetType = null == clazz ? Number.class : clazz;
    }

    @Override
    protected Number convertInternal(Object value) {
        try {
            String valueStr;
            if (Byte.class == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).byteValue();
                }
                String valueStr2 = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr2)) {
                    return null;
                }
                return Byte.valueOf(valueStr2);
            }
            if (Short.class == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).shortValue();
                }
                String valueStr3 = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr3)) {
                    return null;
                }
                return Short.valueOf(valueStr3);
            }
            if (Integer.class == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                String valueStr4 = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr4)) {
                    return null;
                }
                return Integer.valueOf(valueStr4);
            }
            if (Long.class == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).longValue();
                }
                String valueStr5 = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr5)) {
                    return null;
                }
                return Long.valueOf(valueStr5);
            }
            if (Float.class == this.targetType) {
                if (value instanceof Number) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                String valueStr6 = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr6)) {
                    return null;
                }
                return Float.valueOf(valueStr6);
            }
            if (Double.class == this.targetType) {
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                String valueStr7 = this.convertToStr(value);
                if (StrUtil.isBlank(valueStr7)) {
                    return null;
                }
                return Double.valueOf(valueStr7);
            }
            if (BigDecimal.class == this.targetType) {
                return this.toBigDecimal(value);
            }
            if (BigInteger.class == this.targetType) {
                this.toBigInteger(value);
            }
            if (StrUtil.isBlank(valueStr = this.convertToStr(value))) {
                return null;
            }
            return NumberFormat.getInstance().parse(valueStr);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private BigDecimal toBigDecimal(Object value) {
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Double) {
            return new BigDecimal((Double)value);
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        String valueStr = this.convertToStr(value);
        if (StrUtil.isBlank(valueStr)) {
            return null;
        }
        return new BigDecimal(valueStr);
    }

    private BigInteger toBigInteger(Object value) {
        if (value instanceof Long) {
            return BigInteger.valueOf((Long)value);
        }
        String valueStr = this.convertToStr(value);
        if (StrUtil.isBlank(valueStr)) {
            return null;
        }
        return new BigInteger(valueStr);
    }

    @Override
    protected String convertToStr(Object value) {
        String valueStr = super.convertToStr(value);
        return null == valueStr ? null : valueStr.trim();
    }

    @Override
    public Class<Number> getTargetType() {
        return this.targetType;
    }
}

