/*
 * Decompiled with CFR 0.152.
 */
package com.wuweibi.manager.token.lock.impl;

import com.wuweibi.manager.token.lock.LockHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;

public class RedisLockHandler
implements LockHandler {
    private static final Logger log = LoggerFactory.getLogger(RedisLockHandler.class);
    private static final int DEFAULT_SINGLE_EXPIRE_TIME = 30;
    private static final int DEFAULT_BATCH_EXPIRE_TIME = 60;
    private RedisConnectionFactory redisConnectionFactory;
    private String prefix = "lock:";

    public RedisLockHandler(RedisConnectionFactory redisConnectionFactory) {
        this.redisConnectionFactory = redisConnectionFactory;
    }

    @Override
    public boolean tryLock(String key) {
        return this.tryLock(key, 0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(String key, long timeout, TimeUnit unit) {
        String lockKey = this.prefix.concat(key);
        try (RedisConnection connection = this.redisConnectionFactory.getConnection();){
            long nano = System.nanoTime();
            do {
                log.debug("try lock key: {}", (Object)lockKey);
                Boolean status = connection.setNX(lockKey.getBytes(), new byte[1]);
                if (status.booleanValue()) {
                    connection.expire(lockKey.getBytes(), 30L);
                    log.debug("get lock, key: {} , expire in {} seconds.", (Object)lockKey, (Object)30);
                    boolean bl = Boolean.TRUE;
                    return bl;
                }
                log.debug("key: {} locked by another business\uff1a", (Object)lockKey);
                if (timeout <= 0L) break;
                Thread.sleep(30L);
            } while (System.nanoTime() - nano < unit.toNanos(timeout));
            boolean bl = Boolean.FALSE;
            return bl;
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void lock(String key) {
        String lockKey = this.prefix.concat(key);
        try (RedisConnection connection = this.redisConnectionFactory.getConnection();){
            while (true) {
                log.debug("lock key: " + lockKey);
                Boolean status = connection.setNX(lockKey.getBytes(), lockKey.getBytes());
                if (status.booleanValue()) {
                    connection.expire(lockKey.getBytes(), 30L);
                    log.debug("get lock, key: {} , expire in {} seconds.", (Object)lockKey, (Object)30);
                    return;
                }
                log.debug("key: {} locked by another business\uff1a", (Object)lockKey);
                Thread.sleep(300L);
                continue;
                break;
            }
        }
    }

    @Override
    public void unLock(String key) {
        if (null == key) {
            key = "null";
        }
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(key);
        this.unLock(list);
    }

    @Override
    public boolean tryLock(List<String> keyList) {
        return this.tryLock(keyList, 0L, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock(List<String> keyList, long timeout, TimeUnit unit) {
        try (RedisConnection connnection = this.redisConnectionFactory.getConnection();){
            CopyOnWriteArrayList<String> needLocking = new CopyOnWriteArrayList<String>();
            CopyOnWriteArrayList<byte[]> locked = new CopyOnWriteArrayList<byte[]>();
            long nano = System.nanoTime();
            do {
                connnection.openPipeline();
                for (String key : keyList) {
                    String lockKey = this.prefix.concat(key);
                    needLocking.add(lockKey);
                    connnection.setNX(lockKey.getBytes(), lockKey.getBytes());
                }
                log.debug("try lock keys: " + needLocking);
                List results = connnection.closePipeline();
                for (int i = 0; i < results.size(); ++i) {
                    Boolean result = (Boolean)results.get(i);
                    String key = (String)needLocking.get(i);
                    if (!result.booleanValue()) continue;
                    connnection.expire(key.getBytes(), 60L);
                    locked.add(key.getBytes());
                }
                needLocking.removeAll(locked);
                if (needLocking.size() == 0) {
                    boolean bl = true;
                    return bl;
                }
                log.debug("keys: {} locked by another business\uff1a", needLocking);
                if (timeout == 0L) break;
                Thread.sleep(500L);
            } while (System.nanoTime() - nano < unit.toNanos(timeout));
            if (locked.size() > 0) {
                connnection.del((byte[][])locked.toArray((T[])new byte[0][0]));
            }
            boolean bl = false;
            return bl;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unLock(List<String> keyList) {
        CopyOnWriteArrayList<byte[]> keys = new CopyOnWriteArrayList<byte[]>();
        for (String key : keyList) {
            String lockKey = this.prefix.concat(key);
            keys.add(lockKey.getBytes());
        }
        try (RedisConnection connection = this.redisConnectionFactory.getConnection();){
            if (keys.size() > 0) {
                connection.del((byte[][])keys.toArray((T[])new byte[0][]));
                log.debug("release lock, keys : {}", keys);
            }
        }
    }
}

