/*
 * Decompiled with CFR 0.152.
 */
package com.wuweibi.manager.token.listener;

import com.wuweibi.manager.token.TokenManager;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;

public class RedisTokenRefreshListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(RedisTokenRefreshListener.class);
    private ApplicationContext applicationContext;

    public RedisTokenRefreshListener(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void onMessage(Message message, byte[] pattern) {
        log.info("\u76d1\u542c\u6307\u5b9a\u6570\u636e\u5e93\u7684\u6570\u636e-{}", (Object)new String(message.getBody(), StandardCharsets.UTF_8));
        String expiredKey = message.toString();
        if (expiredKey.startsWith("manager:refresh")) {
            String[] keys = expiredKey.split(":");
            String type = keys[2];
            String identify = keys[3];
            List<TokenManager> tokenManagers = this.getTokenManagers();
            Optional<TokenManager> optional = tokenManagers.stream().filter(item -> item.getType().equals(type)).findFirst();
            if (optional.isPresent()) {
                optional.get().refreshToken(identify);
            }
        }
        log.info("message>>>  {}", (Object)message);
        log.info("pattern>>>  {}", (Object)new String(pattern));
        log.info("Redis\u7684\u952e\uff1a{}", (Object)expiredKey);
    }

    private List<TokenManager> getTokenManagers() {
        Map tokenManagers = this.applicationContext.getBeansOfType(TokenManager.class);
        return tokenManagers.entrySet().stream().map(item -> (TokenManager)item.getValue()).collect(Collectors.toList());
    }
}

