/*
 * Decompiled with CFR 0.152.
 */
package com.wuweibi.manager.token.handler;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class LogClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LogClientHttpRequestInterceptor.class);

    public ClientHttpResponse intercept(HttpRequest httpRequest, byte[] bytes, ClientHttpRequestExecution clientHttpRequestExecution) throws IOException {
        log.info("{} {}", (Object)httpRequest.getMethod(), (Object)httpRequest.getURI());
        long startTime = System.currentTimeMillis();
        ClientHttpResponse clientHttpResponse = clientHttpRequestExecution.execute(httpRequest, bytes);
        long etime = System.currentTimeMillis() - startTime;
        log.info("req time={} resp: {}", (Object)etime, (Object)"");
        return clientHttpResponse;
    }
}

