/*
 * Decompiled with CFR 0.152.
 */
package com.wuweibi.manager.token.config.properties;

import com.wuweibi.manager.token.SecretConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

@RefreshScope
@Configuration
@ConfigurationProperties(prefix="spring.token-manager")
public class TokenManagerProperties {
    public static final String PREFIX = "spring.token-manager";
    private String host = "localhost";
    private String password;
    private int database = 14;
    private int port = 3306;
    private String codec = "org.redisson.codec.JsonJacksonCodec";
    private RedisProperties.Lettuce lettuce = new RedisProperties.Lettuce();
    private Map<String, SecretConfig> configMap = new LinkedHashMap<String, SecretConfig>();

    public String getHost() {
        return this.host;
    }

    public String getPassword() {
        return this.password;
    }

    public int getDatabase() {
        return this.database;
    }

    public int getPort() {
        return this.port;
    }

    public String getCodec() {
        return this.codec;
    }

    public RedisProperties.Lettuce getLettuce() {
        return this.lettuce;
    }

    public Map<String, SecretConfig> getConfigMap() {
        return this.configMap;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public void setLettuce(RedisProperties.Lettuce lettuce) {
        this.lettuce = lettuce;
    }

    public void setConfigMap(Map<String, SecretConfig> configMap) {
        this.configMap = configMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenManagerProperties)) {
            return false;
        }
        TokenManagerProperties other = (TokenManagerProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDatabase() != other.getDatabase()) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$codec = this.getCodec();
        String other$codec = other.getCodec();
        if (this$codec == null ? other$codec != null : !this$codec.equals(other$codec)) {
            return false;
        }
        RedisProperties.Lettuce this$lettuce = this.getLettuce();
        RedisProperties.Lettuce other$lettuce = other.getLettuce();
        if (this$lettuce == null ? other$lettuce != null : !this$lettuce.equals(other$lettuce)) {
            return false;
        }
        Map<String, SecretConfig> this$configMap = this.getConfigMap();
        Map<String, SecretConfig> other$configMap = other.getConfigMap();
        return !(this$configMap == null ? other$configMap != null : !((Object)this$configMap).equals(other$configMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TokenManagerProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDatabase();
        result = result * 59 + this.getPort();
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $codec = this.getCodec();
        result = result * 59 + ($codec == null ? 43 : $codec.hashCode());
        RedisProperties.Lettuce $lettuce = this.getLettuce();
        result = result * 59 + ($lettuce == null ? 43 : $lettuce.hashCode());
        Map<String, SecretConfig> $configMap = this.getConfigMap();
        result = result * 59 + ($configMap == null ? 43 : ((Object)$configMap).hashCode());
        return result;
    }

    public String toString() {
        return "TokenManagerProperties(host=" + this.getHost() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", port=" + this.getPort() + ", codec=" + this.getCodec() + ", lettuce=" + this.getLettuce() + ", configMap=" + this.getConfigMap() + ")";
    }
}

