/*
 * Decompiled with CFR 0.152.
 */
package com.wuweibi.manager.token.autoconfigure;

import com.wuweibi.manager.token.config.properties.TokenManagerProperties;
import com.wuweibi.manager.token.listener.RedisTokenRefreshListener;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.SocketOptions;
import javax.annotation.Resource;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;

@Configuration
@ConditionalOnProperty(prefix="spring.token-manager", value={"enabled"}, havingValue="true")
public class TokenManagerRedisAutoConfiguration {
    @Resource
    private TokenManagerProperties tokenManagerProperties;
    @Resource
    private ApplicationContext applicationContext;

    @Bean
    @ConditionalOnProperty(prefix="spring.token-manager", value={"autoRefresh"}, havingValue="true")
    public RedisMessageListenerContainer newRedisMessageListenerContainer() {
        int db = this.tokenManagerProperties.getDatabase();
        RedisMessageListenerContainer listenerContainer = new RedisMessageListenerContainer();
        listenerContainer.setConnectionFactory(this.tokenManagerRedisConnectionFactory());
        String topic = String.format("__keyevent@%d__:expired", db);
        listenerContainer.addMessageListener((MessageListener)new RedisTokenRefreshListener(this.applicationContext), (Topic)new PatternTopic(topic));
        return listenerContainer;
    }

    @Bean(value={"tokenManagerRedisConnectionFactory"})
    public RedisConnectionFactory tokenManagerRedisConnectionFactory() {
        return this.createRedisConnectionFactory(this.tokenManagerProperties.getDatabase());
    }

    public LettuceConnectionFactory createRedisConnectionFactory(int dbIndex) {
        String host = this.tokenManagerProperties.getHost();
        int port = this.tokenManagerProperties.getPort();
        ClientOptions clientOptions = ClientOptions.builder().disconnectedBehavior(ClientOptions.DisconnectedBehavior.REJECT_COMMANDS).autoReconnect(true).socketOptions(SocketOptions.builder().keepAlive(true).build()).build();
        RedisProperties.Lettuce lettuce = this.tokenManagerProperties.getLettuce();
        GenericObjectPoolConfig genericObjectPoolConfig = new GenericObjectPoolConfig();
        genericObjectPoolConfig.setMaxIdle(lettuce.getPool().getMaxIdle());
        genericObjectPoolConfig.setMinIdle(lettuce.getPool().getMinIdle());
        genericObjectPoolConfig.setMaxTotal(lettuce.getPool().getMaxActive());
        genericObjectPoolConfig.setMaxWaitMillis(lettuce.getPool().getMaxWait().toMillis());
        genericObjectPoolConfig.setTimeBetweenEvictionRunsMillis(lettuce.getShutdownTimeout().toMillis());
        LettucePoolingClientConfiguration clientConfig = LettucePoolingClientConfiguration.builder().clientOptions(clientOptions).poolConfig(genericObjectPoolConfig).build();
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration(host, port);
        redisStandaloneConfiguration.setDatabase(dbIndex);
        redisStandaloneConfiguration.setPassword(this.tokenManagerProperties.getPassword());
        return new LettuceConnectionFactory(redisStandaloneConfiguration, (LettuceClientConfiguration)clientConfig);
    }
}

