/*
 * Decompiled with CFR 0.152.
 */
package com.wuweibi.manager.token.autoconfigure;

import com.wuweibi.manager.token.SecretConfig;
import com.wuweibi.manager.token.TokenManager;
import com.wuweibi.manager.token.autoconfigure.TokenManagerRedisAutoConfiguration;
import com.wuweibi.manager.token.config.properties.TokenManagerProperties;
import com.wuweibi.manager.token.handler.LogClientHttpRequestInterceptor;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnProperty(prefix="spring.token-manager", value={"enabled"}, havingValue="true")
@Import(value={TokenManagerRedisAutoConfiguration.class})
@EnableConfigurationProperties(value={TokenManagerProperties.class})
public class TokenManagerAutoConfiguration {
    @Resource
    private TokenManagerProperties tokenManagerProperties;
    @Resource(name="tokenManagerRedisConnectionFactory")
    private RedisConnectionFactory redisConnectionFactory;

    @Bean
    @Order(value=-2147483648)
    public Runnable dynamicConfiguration(ApplicationContext applicationContext) throws Exception {
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)applicationContext;
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)context.getBeanFactory();
        Map<String, SecretConfig> configMap = this.tokenManagerProperties.getConfigMap();
        for (Map.Entry<String, SecretConfig> config : configMap.entrySet()) {
            String key = config.getKey();
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(TokenManager.class);
            beanDefinitionBuilder.addConstructorArgValue((Object)this.restTemplate());
            beanDefinitionBuilder.addConstructorArgValue((Object)config.getValue());
            beanDefinitionBuilder.addConstructorArgValue((Object)this.redisConnectionFactory);
            beanDefinitionBuilder.addPropertyValue("secretConfig", (Object)config.getValue());
            beanDefinitionBuilder.addPropertyValue("redisConnectionFactory", (Object)this.redisConnectionFactory);
            String beanName = String.format("%sTokenManager", key);
            beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
        }
        return null;
    }

    @Bean(value={"tokenManagerRestTemplate"})
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        ArrayList<LogClientHttpRequestInterceptor> interceptors = new ArrayList<LogClientHttpRequestInterceptor>();
        interceptors.add(new LogClientHttpRequestInterceptor());
        restTemplate.setInterceptors(interceptors);
        return restTemplate;
    }
}

