/*
 * Decompiled with CFR 0.152.
 */
package com.wuweibi.manager.token.api.weixin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wuweibi.manager.token.SecretConfig;
import com.wuweibi.manager.token.api.TokenAPI;
import com.wuweibi.manager.token.api.adapter.BaseAPI;
import com.wuweibi.manager.token.bean.TokenInfo;
import com.wuweibi.manager.token.exception.GetTokenException;
import java.net.URI;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.web.client.RestTemplate;

public class WeixinMPAPI
extends BaseAPI
implements TokenAPI {
    public WeixinMPAPI(RestTemplate restTemplate) {
        super(restTemplate);
    }

    @Override
    public TokenInfo getToken(SecretConfig secretConfig, Map<String, Object> params) {
        String appid = secretConfig.getAppid();
        String secret = secretConfig.getAppSecret();
        URI uri = new URIBuilder("https://api.weixin.qq.com/cgi-bin/token").addParameter("grant_type", "client_credential").addParameter("appid", appid).addParameter("secret", secret).build();
        HttpHeaders headers = new HttpHeaders();
        String result = (String)this.restTemplate.getForObject(uri, String.class);
        JSONObject jsonObject = JSON.parseObject((String)result);
        String errcode = jsonObject.getString("errcode");
        if (null != errcode) {
            String errmsg = jsonObject.getString("errmsg");
            throw new GetTokenException(errmsg);
        }
        TokenInfo tokenInfo = new TokenInfo();
        tokenInfo.setAccessToken(jsonObject.getString("access_token"));
        tokenInfo.setExpiresIn(jsonObject.getLong("expires_in"));
        return tokenInfo;
    }
}

