/*
 * Decompiled with CFR 0.152.
 */
package com.wuweibi.manager.token;

import com.alibaba.fastjson.JSON;
import com.wuweibi.manager.token.SecretConfig;
import com.wuweibi.manager.token.api.TokenAPI;
import com.wuweibi.manager.token.api.weixin.WeixinMPAPI;
import com.wuweibi.manager.token.bean.TokenInfo;
import com.wuweibi.manager.token.constant.ConfigType;
import com.wuweibi.manager.token.exception.GetTokenException;
import com.wuweibi.manager.token.lock.LockHandler;
import com.wuweibi.manager.token.lock.impl.RedisLockHandler;
import com.wuweibi.manager.token.utils.SpringUtil;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.web.client.RestTemplate;

public class TokenManager {
    private static final Logger log = LoggerFactory.getLogger(TokenManager.class);
    private SecretConfig secretConfig;
    private TokenAPI tokenAPI;
    private RedisConnectionFactory redisConnectionFactory;
    private LockHandler lockHandler;

    private TokenManager() {
    }

    public TokenManager(RestTemplate restTemplate, SecretConfig secretConfig, RedisConnectionFactory redisConnectionFactory) {
        this.secretConfig = secretConfig;
        this.redisConnectionFactory = redisConnectionFactory;
        this.lockHandler = new RedisLockHandler(redisConnectionFactory);
        if (ConfigType.WEIXIN.equals(secretConfig.getType())) {
            this.tokenAPI = new WeixinMPAPI(restTemplate);
        }
    }

    public TokenInfo getToken() {
        return this.getToken("");
    }

    public TokenInfo getToken(String params) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(2);
        paramsMap.put("params", params);
        paramsMap.put("tag", params);
        return this.getToken(paramsMap);
    }

    public TokenInfo getToken(Map<String, Object> params) {
        TokenInfo tokenInfo;
        block20: {
            TokenInfo tokenInfo2;
            String lockKey;
            RedisConnection redisConnection;
            byte[] key2Bytes;
            byte[] keyBytes;
            block18: {
                TokenInfo tokenInfo3;
                block19: {
                    String profile;
                    String identify;
                    block16: {
                        TokenInfo tokenInfo4;
                        block17: {
                            TokenInfo tokenInfo5;
                            identify = (String)params.get("tag");
                            if (identify == null) {
                                throw new RuntimeException("token cache tag not null");
                            }
                            if (this.secretConfig.getAppid() != null) {
                                identify = this.secretConfig.getAppid() + ("".equals(identify) ? "" : "" + identify);
                            }
                            profile = this.getEnvironment();
                            String key = String.format("manager:token%s:%s:%s", profile, this.secretConfig.getType(), identify);
                            String key2 = String.format("manager:refresh%s:%s:%s", profile, this.secretConfig.getType(), identify);
                            keyBytes = key.getBytes(StandardCharsets.UTF_8);
                            key2Bytes = key2.getBytes(StandardCharsets.UTF_8);
                            redisConnection = null;
                            lockKey = null;
                            if (!this.secretConfig.isCacheEnable() || (tokenInfo5 = this.getTokenInfo(keyBytes, redisConnection = this.redisConnectionFactory.getConnection())) == null) break block16;
                            tokenInfo4 = tokenInfo5;
                            if (lockKey != null) {
                                this.lockHandler.unLock(lockKey);
                            }
                            if (redisConnection == null) break block17;
                            redisConnection.close();
                        }
                        return tokenInfo4;
                    }
                    lockKey = String.format("manager:lock%s:%s", profile, identify);
                    boolean status = this.lockHandler.tryLock(lockKey, 10L, TimeUnit.SECONDS);
                    if (!status) {
                        throw new RuntimeException("\u670d\u52a1\u5668\u7e41\u5fd9");
                    }
                    if (!this.secretConfig.isCacheEnable() || (tokenInfo2 = this.getTokenInfo(keyBytes, redisConnection)) == null) break block18;
                    tokenInfo3 = tokenInfo2;
                    if (lockKey != null) {
                        this.lockHandler.unLock(lockKey);
                    }
                    if (redisConnection == null) break block19;
                    redisConnection.close();
                }
                return tokenInfo3;
            }
            try {
                tokenInfo2 = this.tokenAPI.getToken(this.secretConfig, params);
                if (this.secretConfig.isCacheEnable()) {
                    if (tokenInfo2.getExpiresIn() <= this.secretConfig.getOffsetTime().getSeconds()) {
                        throw new GetTokenException("Token\u751f\u547d\u5468\u671f\u5c0f\u4e8e\u504f\u79fb\u65f6\u95f4");
                    }
                    long cycleTime = tokenInfo2.getExpiresIn() - this.secretConfig.getOffsetTime().getSeconds();
                    byte[] bytes = JSON.toJSONString((Object)tokenInfo2).getBytes(StandardCharsets.UTF_8);
                    redisConnection.set(keyBytes, bytes);
                    redisConnection.expire(keyBytes, cycleTime);
                    redisConnection.set(key2Bytes, bytes);
                    redisConnection.expire(key2Bytes, cycleTime);
                }
                tokenInfo = tokenInfo2;
                if (lockKey != null) {
                    this.lockHandler.unLock(lockKey);
                }
                if (redisConnection == null) break block20;
            }
            catch (Exception e) {
                try {
                    log.error("", (Throwable)e);
                    throw new GetTokenException(e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    if (lockKey != null) {
                        this.lockHandler.unLock(lockKey);
                    }
                    if (redisConnection != null) {
                        redisConnection.close();
                    }
                    throw throwable;
                }
            }
            redisConnection.close();
        }
        return tokenInfo;
    }

    private TokenInfo getTokenInfo(byte[] keyBytes, RedisConnection redisConnection) {
        byte[] bytes = redisConnection.get(keyBytes);
        if (bytes != null) {
            TokenInfo tokenInfo = (TokenInfo)JSON.parseObject((String)new String(bytes), TokenInfo.class);
            long expires = redisConnection.ttl(keyBytes, TimeUnit.SECONDS);
            tokenInfo.setExpiresIn(expires);
            return tokenInfo;
        }
        return null;
    }

    public void setTokenAPI(TokenAPI tokenAPI) {
        if (this.tokenAPI != null) {
            log.warn("TokenManager has tokenAPi impl\uff01\uff01\uff01use custom tokenAPI.");
            throw new GetTokenException("TokenManager has tokenAPi impl");
        }
        this.tokenAPI = tokenAPI;
    }

    public String getType() {
        return this.secretConfig.getType();
    }

    public void refreshToken(String identify) {
        if (!this.secretConfig.isEnableRefreshToken()) {
            log.info("updateToken() {} not open RefreshToken", (Object)this.secretConfig.getType());
            return;
        }
        throw new GetTokenException("\u6ca1\u6709\u5b9e\u73b0refreshToken");
    }

    public void cleanToken() {
        this.cleanToken(this.secretConfig.getAppid());
    }

    public void cleanToken(String identify) {
        String profile = this.getEnvironment();
        String key = String.format("manager:token%s:%s:%s", profile, this.secretConfig.getType(), identify);
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        RedisConnection redisConnection = this.redisConnectionFactory.getConnection();
        String lockey = String.format("manager:lock%s:%s", profile, identify);
        boolean status = this.lockHandler.tryLock(lockey, 10L, TimeUnit.SECONDS);
        if (!status) {
            throw new GetTokenException("\u670d\u52a1\u5668\u7e41\u5fd9");
        }
        try {
            redisConnection.del((byte[][])new byte[][]{keyBytes});
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        finally {
            this.lockHandler.unLock(lockey);
            redisConnection.close();
        }
    }

    private String getEnvironment() {
        String profile = "";
        if (this.secretConfig.isMultiEnv()) {
            profile = String.format(":%s", SpringUtil.getProfilesActive());
        }
        return profile;
    }

    public SecretConfig getSecretConfig() {
        return this.secretConfig;
    }

    public TokenAPI getTokenAPI() {
        return this.tokenAPI;
    }

    public RedisConnectionFactory getRedisConnectionFactory() {
        return this.redisConnectionFactory;
    }

    public LockHandler getLockHandler() {
        return this.lockHandler;
    }

    public void setSecretConfig(SecretConfig secretConfig) {
        this.secretConfig = secretConfig;
    }

    public void setRedisConnectionFactory(RedisConnectionFactory redisConnectionFactory) {
        this.redisConnectionFactory = redisConnectionFactory;
    }

    public void setLockHandler(LockHandler lockHandler) {
        this.lockHandler = lockHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenManager)) {
            return false;
        }
        TokenManager other = (TokenManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SecretConfig this$secretConfig = this.getSecretConfig();
        SecretConfig other$secretConfig = other.getSecretConfig();
        if (this$secretConfig == null ? other$secretConfig != null : !((Object)this$secretConfig).equals(other$secretConfig)) {
            return false;
        }
        TokenAPI this$tokenAPI = this.getTokenAPI();
        TokenAPI other$tokenAPI = other.getTokenAPI();
        if (this$tokenAPI == null ? other$tokenAPI != null : !this$tokenAPI.equals(other$tokenAPI)) {
            return false;
        }
        RedisConnectionFactory this$redisConnectionFactory = this.getRedisConnectionFactory();
        RedisConnectionFactory other$redisConnectionFactory = other.getRedisConnectionFactory();
        if (this$redisConnectionFactory == null ? other$redisConnectionFactory != null : !this$redisConnectionFactory.equals(other$redisConnectionFactory)) {
            return false;
        }
        LockHandler this$lockHandler = this.getLockHandler();
        LockHandler other$lockHandler = other.getLockHandler();
        return !(this$lockHandler == null ? other$lockHandler != null : !this$lockHandler.equals(other$lockHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TokenManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SecretConfig $secretConfig = this.getSecretConfig();
        result = result * 59 + ($secretConfig == null ? 43 : ((Object)$secretConfig).hashCode());
        TokenAPI $tokenAPI = this.getTokenAPI();
        result = result * 59 + ($tokenAPI == null ? 43 : $tokenAPI.hashCode());
        RedisConnectionFactory $redisConnectionFactory = this.getRedisConnectionFactory();
        result = result * 59 + ($redisConnectionFactory == null ? 43 : $redisConnectionFactory.hashCode());
        LockHandler $lockHandler = this.getLockHandler();
        result = result * 59 + ($lockHandler == null ? 43 : $lockHandler.hashCode());
        return result;
    }

    public String toString() {
        return "TokenManager(secretConfig=" + this.getSecretConfig() + ", tokenAPI=" + this.getTokenAPI() + ", redisConnectionFactory=" + this.getRedisConnectionFactory() + ", lockHandler=" + this.getLockHandler() + ")";
    }
}

