/*
 * Decompiled with CFR 0.152.
 */
package com.wolvereness.overmapped.lib;

import com.google.common.collect.ImmutableList;
import com.wolvereness.overmapped.lib.MultiProcessor;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class ProperProcessor
extends MultiProcessor {
    static final AtomicIntegerFieldUpdater<Task<?>> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Task.class, "state");
    private final BlockingQueue<Task<?>> queue = new LinkedBlockingQueue();
    private final Collection<Thread> threads;

    public ProperProcessor(int threadCount, ThreadFactory factory) {
        ImmutableList.Builder threads = ImmutableList.builder();
        while (threadCount-- >= 1) {
            Thread thread = factory.newThread(new Runnable(){

                @Override
                public void run() {
                    block3: {
                        BlockingQueue queue = ProperProcessor.this.queue;
                        try {
                            while (!ProperProcessor.this.shutdown) {
                                ((Task)queue.take()).handle();
                            }
                        }
                        catch (InterruptedException ex) {
                            if (ProperProcessor.this.shutdown) break block3;
                            throw new IllegalStateException("Interrupted innappropriately", ex);
                        }
                    }
                }
            });
            threads.add((Object)thread);
        }
        this.threads = threads.build();
        final Iterator it = this.threads.iterator();
        Thread initial = (Thread)it.next();
        if (it.hasNext()) {
            this.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    while (it.hasNext()) {
                        ((Thread)it.next()).start();
                    }
                    return null;
                }
            });
        }
        initial.start();
    }

    @Override
    public void shutdown() {
        Task task;
        if (this.shutdown) {
            return;
        }
        super.shutdown();
        BlockingQueue<Task<?>> queue = this.queue;
        while ((task = (Task)queue.poll()) != null) {
            task.cancel(false);
        }
        for (Thread thread : this.threads) {
            thread.interrupt();
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        super.checkShutdown();
        Task<T> task = new Task<T>(callable);
        this.queue.add(task);
        return task;
    }

    class Task<T>
    implements Future<T> {
        private static final int READY = 0;
        private static final int PROCESSING = 1;
        private static final int WAITING = 2;
        private static final int DONE = 3;
        private static final int EXCEPTION = 4;
        private static final int CANCELLED = 5;
        final Callable<T> callable;
        private Throwable exception;
        private T value;
        volatile int state;

        Task(Callable<T> callable) {
            this.callable = callable;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return STATE_UPDATER.compareAndSet(this, 0, 5);
        }

        @Override
        public boolean isCancelled() {
            return this.state == 5;
        }

        @Override
        public boolean isDone() {
            int state = this.state;
            return state == 3 || state == 5;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException, CancellationException {
            block8: while (true) {
                switch (this.state) {
                    case 3: {
                        return this.value;
                    }
                    case 4: {
                        throw new ExecutionException(this.exception);
                    }
                    case 5: {
                        throw new CancellationException();
                    }
                    case 1: {
                        if (!STATE_UPDATER.compareAndSet(this, 1, 2)) continue block8;
                    }
                    case 2: {
                        this.impatientlyWait();
                        continue block8;
                    }
                    case 0: {
                        this.handle();
                        continue block8;
                    }
                }
                break;
            }
            throw new AssertionError((Object)("Unexpected value of state: " + this.state));
        }

        void handle() {
            if (STATE_UPDATER.compareAndSet(this, 0, 1)) {
                this.calculate();
            }
        }

        private void calculate() {
            block3: {
                try {
                    this.value = this.callable.call();
                    if (!STATE_UPDATER.compareAndSet(this, 1, 3)) {
                        this.notifyWaitting(3);
                    }
                }
                catch (Throwable ex) {
                    this.exception = ex;
                    if (STATE_UPDATER.compareAndSet(this, 1, 4)) break block3;
                    this.notifyWaitting(4);
                }
            }
        }

        private void impatientlyWait() throws InterruptedException {
            BlockingQueue queue = ProperProcessor.this.queue;
            while (true) {
                if (this.state != 2) {
                    return;
                }
                Task t = (Task)queue.poll();
                if (t == null) break;
                t.handle();
            }
            this.patientlyWait();
        }

        private synchronized void patientlyWait() throws InterruptedException {
            while (this.state == 2) {
                this.wait();
            }
        }

        private synchronized void notifyWaitting(int newState) {
            this.state = newState;
            this.notifyAll();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new UnsupportedOperationException("Cannot time waiting for a MultiProcessor");
        }
    }
}

