/*
 * Decompiled with CFR 0.152.
 */
package com.wolvereness.overmapped.lib;

import com.wolvereness.overmapped.lib.ProperProcessor;
import com.wolvereness.overmapped.lib.SingletonProcessor;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.Validate;

public abstract class MultiProcessor {
    volatile boolean shutdown;

    public static MultiProcessor newMultiProcessor(int threads, ThreadFactory factory) {
        Validate.isTrue((threads >= 0 ? 1 : 0) != 0, (String)"Cannot have negative threads", (Object[])new Object[0]);
        return threads == 0 ? new SingletonProcessor() : new ProperProcessor(threads, factory);
    }

    public void shutdown() {
        this.shutdown = true;
    }

    final void checkShutdown() {
        if (this.shutdown) {
            throw new IllegalStateException("Cannot submit tasks to shutdown processor");
        }
    }

    public abstract <T> Future<T> submit(Callable<T> var1);
}

