/*
 * Decompiled with CFR 0.152.
 */
package com.wolvereness.overmapped.asm;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.wolvereness.overmapped.asm.Signature;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;

public final class ByteClass {
    static final String FILE_POSTFIX = ".class";
    private final ClassReader reader;
    private final String token;
    private final String parent;
    private final List<String> interfaces;
    private final List<Signature> localSignatures;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteClass(String name, InputStream data) throws IOException {
        Validate.notNull((Object)name, (String)"File name cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)data, (String)"InputStream cannot be null", (Object[])new Object[0]);
        Validate.isTrue((boolean)name.toLowerCase().endsWith(FILE_POSTFIX), (String)"File name must be a class file", (Object[])new Object[0]);
        this.token = name.substring(0, name.length() - FILE_POSTFIX.length());
        final MutableObject parent = new MutableObject();
        final ImmutableList.Builder interfaces = ImmutableList.builder();
        final ImmutableList.Builder localSignatures = ImmutableList.builder();
        try {
            this.reader = new ClassReader(ByteStreams.toByteArray((InputStream)data));
        }
        finally {
            try {
                data.close();
            }
            catch (IOException iOException) {}
        }
        this.reader.accept(new ClassVisitor(262144){

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                localSignatures.add((Object)new Signature(ByteClass.this.getToken(), name, desc));
                return super.visitField(access, name, desc, signature, value);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                localSignatures.add((Object)new Signature(ByteClass.this.getToken(), name, desc));
                return super.visitMethod(access, name, desc, signature, exceptions);
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfacesArray) {
                super.visit(version, access, name, signature, superName, interfacesArray);
                parent.setValue((Object)superName);
                if (!name.equals(ByteClass.this.getToken())) {
                    throw new IllegalArgumentException(name + " is not " + ByteClass.this.getToken());
                }
                for (String interfaceName : interfacesArray) {
                    if (interfaceName.startsWith("java.") || interfaceName.startsWith("javax.")) continue;
                    interfaces.add((Object)interfaceName);
                }
            }
        }, 1);
        this.parent = (String)parent.getValue();
        this.interfaces = interfaces.build();
        this.localSignatures = localSignatures.build();
    }

    public String getToken() {
        return this.token;
    }

    public String getParent() {
        return this.parent;
    }

    public List<String> getInterfaces() {
        return this.interfaces;
    }

    public List<Signature> getLocalSignatures() {
        return this.localSignatures;
    }

    public Callable<Pair<ZipEntry, byte[]>> callable(final Map<Signature, Signature> signatures, final Map<String, String> classMaps, final Map<String, ByteClass> classes, final Map<Signature, Integer> flags) {
        return new Callable<Pair<ZipEntry, byte[]>>(){

            @Override
            public Pair<ZipEntry, byte[]> call() throws Exception {
                return ByteClass.this.call(signatures, classMaps, classes, flags);
            }
        };
    }

    public Pair<ZipEntry, byte[]> call(final Map<Signature, Signature> signatures, final Map<String, String> classMaps, Map<String, ByteClass> classes, final Map<Signature, Integer> flags) throws Exception {
        final Signature.MutableSignature signature = new Signature.MutableSignature("", "", "");
        ClassWriter writer = new ClassWriter(0);
        this.reader.accept((ClassVisitor)new RemappingClassAdapter((ClassVisitor)writer, new Remapper(){

            public String mapMethodName(String owner, String name, String desc) {
                return signature.update(owner, name, desc, signatures).getElementName();
            }

            public String mapFieldName(String owner, String name, String desc) {
                return signature.update(owner, name, desc, signatures).getElementName();
            }

            public String map(String typeName) {
                String name = (String)classMaps.get(typeName);
                if (name != null) {
                    return name;
                }
                return typeName;
            }
        }){

            public FieldVisitor visitField(int access, String name, String desc, String generics, Object value) {
                return super.visitField(signature.updateAndGet(ByteClass.this.getToken(), name, desc, flags, access).intValue(), name, desc, generics, value);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String generics, String[] exceptions) {
                return super.visitMethod(signature.updateAndGet(ByteClass.this.getToken(), name, desc, flags, access).intValue(), name, desc, generics, exceptions);
            }
        }, 8);
        return new ImmutablePair((Object)new ZipEntry(classMaps.get(this.token) + FILE_POSTFIX), (Object)writer.toByteArray());
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.token + " _ " + this.parent + this.interfaces + "):" + this.localSignatures;
    }

    public static boolean isClass(String name) {
        return name.endsWith(FILE_POSTFIX);
    }
}

