/*
 * Decompiled with CFR 0.152.
 */
package com.wolvereness.overmapped;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.wolvereness.overmapped.Missing;
import com.wolvereness.overmapped.asm.ByteClass;
import com.wolvereness.overmapped.asm.Signature;
import com.wolvereness.overmapped.lib.MultiProcessor;
import com.wolvereness.overmapped.lib.WellOrdered;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.objectweb.asm.commons.Remapper;
import org.yaml.snakeyaml.Yaml;

@Mojo(name="map")
public class OverMapped
extends AbstractMojo
implements Thread.UncaughtExceptionHandler {
    @Parameter(required=true, property="mapping.maps")
    private File maps;
    @Parameter(required=true, property="mapping.input")
    private File input;
    @Parameter(required=false, property="mapping.output")
    private File output;
    @Parameter(required=false, property="mapping.original")
    private File original;
    @Parameter(defaultValue="2", property="mapping.cores")
    private int cores;
    @Parameter(defaultValue="WARN", required=true, property="mapping.missing")
    private String missing;
    private Missing missingAction = Missing.WARN;
    private volatile Pair<Thread, Throwable> uncaught;

    public void execute() throws MojoExecutionException, MojoFailureException {
        InputStream license = OverMapped.class.getResourceAsStream("/COPYING.HEADER.TXT");
        if (license != null) {
            try {
                this.getLog().info((CharSequence)new String(ByteStreams.toByteArray((InputStream)license), "UTF8"));
            }
            catch (IOException ex) {
                this.getLog().warn((CharSequence)"Missing LICENSE data", (Throwable)ex);
            }
            finally {
                try {
                    license.close();
                }
                catch (IOException ex) {}
            }
        } else {
            this.getLog().warn((CharSequence)"Missing LICENSE data");
        }
        try {
            this.process();
        }
        catch (MojoExecutionException ex) {
            throw ex;
        }
        catch (MojoFailureException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new MojoExecutionException(null, t);
        }
    }

    public void process() throws Throwable {
        this.validateInput();
        MultiProcessor executor = MultiProcessor.newMultiProcessor(this.cores - 1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(OverMapped.class.getName() + "-processor-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)this).build());
        Future<Object> fileCopy = executor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (OverMapped.this.original != null) {
                    if (OverMapped.this.original.exists()) {
                        OverMapped.this.original.delete();
                    }
                    Files.copy((File)OverMapped.this.input, (File)OverMapped.this.original);
                }
                return null;
            }
        });
        Future mappings = executor.submit(new Callable<Iterable<?>>(){

            @Override
            public Iterable<?> call() throws Exception {
                Object yaml = new Yaml().load(Files.toString((File)OverMapped.this.maps, (Charset)Charset.forName("UTF8")));
                if (yaml instanceof Iterable) {
                    return (Iterable)yaml;
                }
                if (yaml instanceof Map) {
                    return ImmutableList.of((Object)yaml);
                }
                throw new ClassCastException(String.format("%s (%s) implements neither %s nor %s", yaml, yaml == null ? Object.class : yaml.getClass(), Iterable.class, Map.class));
            }
        });
        LinkedHashMap byteClasses = Maps.newLinkedHashMap();
        ArrayList fileEntries = Lists.newArrayList();
        this.readClasses(executor, byteClasses, fileEntries);
        try {
            this.reorderEntries(byteClasses);
        }
        catch (WellOrdered.CircularOrderException ex) {
            MojoFailureException throwable = new MojoFailureException("Circular class hiearchy detected");
            throwable.initCause(ex);
            throw throwable;
        }
        Multimap<String, String> depends = this.processDepends(byteClasses);
        Multimap<String, String> rdepends = this.processReverseDepends(depends);
        HashBiMap nameMaps = HashBiMap.create((int)byteClasses.size());
        final BiMap inverseNameMaps = nameMaps.inverse();
        HashBiMap signatureMaps = HashBiMap.create();
        BiMap inverseSignatureMaps = signatureMaps.inverse();
        HashMap flags = Maps.newHashMap();
        Remapper inverseMapper = new Remapper(){

            public String map(String typeName) {
                String name = (String)inverseNameMaps.get((Object)typeName);
                if (name != null) {
                    return name;
                }
                return typeName;
            }
        };
        this.prepareSignatures(byteClasses, rdepends, (BiMap<String, String>)nameMaps, (BiMap<Signature, Signature>)signatureMaps);
        Signature.MutableSignature signature = Signature.newMutableSignature("", "", "");
        HashSet searchCache = Sets.newHashSet();
        for (Object mapping : (Iterable)mappings.get()) {
            Object throwable;
            Map map = (Map)mapping;
            try {
                Object classMaps = map.get("classes");
                if (classMaps instanceof Map) {
                    for (Map.Entry entry : ((Map)classMaps).entrySet()) {
                        String originalName = ((String)entry.getKey()).toString();
                        String newName = ((String)entry.getValue()).toString();
                        if (nameMaps.containsValue((Object)newName)) {
                            throw new MojoFailureException(String.format("Cannot map `%s' to a duplicate entry `%s' mapped from `%s'", originalName, newName, inverseNameMaps.get((Object)newName)));
                        }
                        String trueOriginal = (String)inverseNameMaps.get((Object)originalName);
                        if (trueOriginal == null) {
                            this.missingAction.actClass(this.getLog(), originalName, newName, (Map<String, String>)inverseNameMaps);
                            continue;
                        }
                        nameMaps.put((Object)trueOriginal, (Object)newName);
                    }
                }
            }
            catch (Exception ex) {
                throwable = new MojoFailureException("Failed to parse class mappings in " + mapping);
                ((Throwable)throwable).initCause(ex);
                throw throwable;
            }
            try {
                Object memberMaps = map.get("members");
                if (memberMaps instanceof Map) {
                    for (Map.Entry entry : ((Map)memberMaps).entrySet()) {
                        String description;
                        String newName;
                        String name;
                        ImmutableCollection classes;
                        Object key = entry.getKey();
                        if (key instanceof Iterable) {
                            ImmutableList.Builder classesBuilder = ImmutableList.builder();
                            for (Object clazz : (Iterable)key) {
                                classesBuilder.add((Object)this.asType(clazz, "`%4$s' contains a %2$s `%1$s', expected a %5$s, from `%3$s'", false, memberMaps, key, String.class));
                            }
                            classes = classesBuilder.build();
                            Map information = this.asType(entry.getValue(), "Expected a value `%4$s'->%5$s in %3%s, got %2$s `%1$s'", false, memberMaps, key, Map.class);
                            name = this.getStringFrom(information, "name", false);
                            newName = this.getStringFrom(information, "map", false);
                            description = this.getStringFrom(information, "description", true);
                        } else {
                            int finalSpace;
                            String qualifiedName = this.asType(key, "`%4$s' points from a %2$s `%1$s', expected a %5$s, in `%3$s'", false, memberMaps, entry, String.class);
                            int firstSpace = qualifiedName.indexOf(32);
                            if (firstSpace == (finalSpace = qualifiedName.lastIndexOf(32))) {
                                if (firstSpace == -1) {
                                    throw new MojoFailureException(String.format("Malformed mapping %s", qualifiedName));
                                }
                                classes = ImmutableList.of((Object)qualifiedName.substring(0, firstSpace));
                                name = qualifiedName.substring(finalSpace + 1);
                                description = null;
                            } else {
                                if (qualifiedName.indexOf(32, firstSpace + 1) != finalSpace) {
                                    throw new MojoFailureException(String.format("Malformed mapping %s", qualifiedName));
                                }
                                classes = ImmutableList.of((Object)qualifiedName.substring(0, firstSpace));
                                name = qualifiedName.substring(firstSpace + 1, finalSpace);
                                description = qualifiedName.substring(finalSpace + 1);
                            }
                            newName = this.asType(entry.getValue(), "`%4$s' points from a %2$s `%1$s', expected a %5$s, in `%3$s'", false, memberMaps, entry, String.class);
                        }
                        if (description == null) {
                            this.getLog().warn((CharSequence)String.format("Wildcard description matching not yet implemented - %s %s->%s", classes, name, newName));
                            continue;
                        }
                        String unmappedDescription = inverseMapper.mapDesc(description);
                        for (String clazz : classes) {
                            String original = (String)inverseNameMaps.get((Object)clazz);
                            if (original == null) {
                                this.missingAction.actMember(this.getLog(), clazz, name, newName, description, (Map<Signature, Signature>)inverseSignatureMaps);
                                continue;
                            }
                            if (!this.updateMember(searchCache, (BiMap<Signature, Signature>)signatureMaps, (BiMap<Signature, Signature>)inverseSignatureMaps, signature, name, newName, description, unmappedDescription, clazz, original) || !signature.isMethod()) continue;
                            for (String inherited : rdepends.get((Object)original)) {
                                this.updateMember(searchCache, (BiMap<Signature, Signature>)signatureMaps, (BiMap<Signature, Signature>)inverseSignatureMaps, signature, name, newName, description, unmappedDescription, (String)nameMaps.get((Object)inherited), inherited);
                            }
                        }
                        searchCache.clear();
                    }
                }
            }
            catch (Exception ex) {
                throwable = new MojoFailureException("Failed to parse member mappings in " + mapping);
                ((Throwable)throwable).initCause(ex);
                throw throwable;
            }
            try {
                Object flagMaps = map.get("flags");
                if (!(flagMaps instanceof Map)) continue;
                for (Map.Entry entry : ((Map)flagMaps).entrySet()) {
                    int finalSpace;
                    String qualifiedName = this.asType(entry.getKey(), "`%4$s' points from a %2$s `%1$s', expected a %5$s, in `%3$s'", false, flagMaps, entry, String.class);
                    Integer flag = this.asType(entry.getValue(), "Expected a value `%4$s'->%5$s in %3%s, got %2$s `%1$s'", false, flagMaps, qualifiedName, Integer.class);
                    int firstSpace = qualifiedName.indexOf(32);
                    if (firstSpace == (finalSpace = qualifiedName.lastIndexOf(32)) || qualifiedName.indexOf(32, firstSpace + 1) != finalSpace) {
                        throw new MojoFailureException(String.format("Malformed mapping %s", qualifiedName));
                    }
                    String clazz = qualifiedName.substring(0, firstSpace);
                    String name = qualifiedName.substring(firstSpace + 1, finalSpace);
                    String description = qualifiedName.substring(finalSpace + 1);
                    String unmappedClass = (String)inverseNameMaps.get((Object)clazz);
                    if (unmappedClass == null) {
                        this.missingAction.actFlag(this.getLog(), entry, (Map<Signature, Signature>)signatureMaps);
                        continue;
                    }
                    String unmappedDescription = inverseMapper.mapDesc(description);
                    Signature unmappedSignature = (Signature)inverseSignatureMaps.get((Object)signature.update(unmappedClass, name, unmappedDescription));
                    if (unmappedSignature == null) {
                        this.missingAction.actFlag(this.getLog(), entry, (Map<Signature, Signature>)signatureMaps);
                        continue;
                    }
                    flags.put(unmappedSignature, flag);
                }
            }
            catch (Exception ex) {
                throwable = new MojoFailureException("Failed to parse class mappings in " + mapping);
                ((Throwable)throwable).initCause(ex);
                throw throwable;
            }
        }
        try {
            fileCopy.get();
        }
        catch (ExecutionException ex) {
            throw new MojoFailureException(String.format("Could not copy `%s' to `%s'", this.input, this.original));
        }
        this.writeToFile(executor, byteClasses, fileEntries, (BiMap<String, String>)nameMaps, (BiMap<Signature, Signature>)signatureMaps, flags);
        executor.shutdown();
        Pair<Thread, Throwable> uncaught = this.uncaught;
        if (uncaught != null) {
            throw new MojoExecutionException(String.format("Uncaught exception in %s", uncaught.getLeft()), (Throwable)uncaught.getRight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(MultiProcessor executor, Map<String, ByteClass> byteClasses, List<Pair<ZipEntry, byte[]>> fileEntries, BiMap<String, String> nameMaps, BiMap<Signature, Signature> signatureMaps, Map<Signature, Integer> flags) throws IOException, FileNotFoundException, InterruptedException, ExecutionException {
        ArrayList classWrites = Lists.newArrayList();
        for (ByteClass clazz : byteClasses.values()) {
            classWrites.add(executor.submit(clazz.callable((Map<Signature, Signature>)signatureMaps, (Map<String, String>)nameMaps, byteClasses, flags)));
        }
        FileOutputStream fileOut = null;
        ZipOutputStream jar = null;
        try {
            fileOut = new FileOutputStream(this.output);
            jar = new JarOutputStream(fileOut);
            for (Pair<ZipEntry, byte[]> fileEntry : fileEntries) {
                ((JarOutputStream)jar).putNextEntry((ZipEntry)fileEntry.getLeft());
                jar.write((byte[])fileEntry.getRight());
            }
            for (Future fileEntryFuture : classWrites) {
                Pair fileEntry = (Pair)fileEntryFuture.get();
                ((JarOutputStream)jar).putNextEntry((ZipEntry)fileEntry.getLeft());
                jar.write((byte[])fileEntry.getRight());
            }
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean updateMember(Set<String> cache, BiMap<Signature, Signature> signatureMaps, BiMap<Signature, Signature> inverseSignatureMaps, Signature.MutableSignature signature, String name, String newName, String description, String unmappedDescription, String clazz, String original) throws MojoFailureException {
        if (!cache.add(original)) {
            return false;
        }
        signature.update(original, name, unmappedDescription);
        Signature originalSignature = (Signature)inverseSignatureMaps.get((Object)signature);
        if (originalSignature != null) {
            try {
                signatureMaps.put((Object)originalSignature, (Object)signature.forElementName(newName));
            }
            catch (IllegalArgumentException ex) {
                MojoFailureException mojoEx = new MojoFailureException(String.format("Cannot map %s (currently %s) to pre-existing member %s (in class %s)", originalSignature, signature, signature.forElementName(newName), clazz));
                mojoEx.initCause((Throwable)ex);
                throw mojoEx;
            }
        } else {
            this.missingAction.actMember(this.getLog(), clazz, name, newName, description, (Map<Signature, Signature>)inverseSignatureMaps);
        }
        return true;
    }

    private String getStringFrom(Map<?, ?> map, String token, boolean acceptNull) throws ClassCastException, NullPointerException {
        return this.getTypeFrom(map, token, acceptNull, String.class);
    }

    private <T> T getTypeFrom(Map<?, ?> map, String token, boolean acceptNull, Class<T> clazz) throws ClassCastException, NullPointerException {
        return this.asType(map.get(token), "Expected a token \"%4$s\"->%5$s in `%3s', got %2$s `%1$s'", acceptNull, map, token, clazz);
    }

    private <T> T asType(Object value, String message, boolean acceptNull, Object source, Object identifier, Class<T> clazz) throws ClassCastException, NullPointerException {
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        if (acceptNull && value == null) {
            return null;
        }
        String exceptionMessage = String.format(message, value, value == null ? Object.class : value.getClass(), source, identifier, clazz);
        if (value == null) {
            throw new NullPointerException(exceptionMessage);
        }
        throw new ClassCastException(exceptionMessage);
    }

    private void validateInput() throws MojoExecutionException, MojoFailureException {
        if (this.cores <= 0) {
            throw new MojoExecutionException(String.format("Cannot process with no cores: `%d'", this.cores));
        }
        if (!this.maps.exists() || this.maps.isDirectory()) {
            throw new MojoFailureException(String.format("Cannot process non-existant maps file `%s'", this.maps));
        }
        if (!this.input.exists() || this.input.isDirectory()) {
            throw new MojoFailureException(String.format("Cannot process non-existent input file `%s'", this.input));
        }
        this.verifyOut(this.output);
        this.verifyOut(this.original);
        if (this.output == null) {
            this.output = this.input;
        }
        try {
            this.missingAction = Missing.valueOf(this.missing);
        }
        catch (IllegalArgumentException ex) {
            this.getLog().warn((CharSequence)String.format("Unknown value for mapping.missing: %s, using default %s", this.missing, this.missingAction.name()), (Throwable)ex);
        }
    }

    private void prepareSignatures(Map<String, ByteClass> byteClasses, Multimap<String, String> rdepends, BiMap<String, String> nameMaps, BiMap<Signature, Signature> signatureMaps) {
        for (ByteClass clazz : byteClasses.values()) {
            if (this.missingAction == Missing.VERBOSE) {
                this.getLog().info((CharSequence)("Loading class: " + clazz));
            }
            String name = clazz.getToken();
            nameMaps.put((Object)name, (Object)name);
            ImmutableSet reverseDependencies = rdepends.containsKey((Object)name) ? rdepends.get((Object)name) : ImmutableSet.of();
            for (Signature signature : clazz.getLocalSignatures()) {
                signatureMaps.put((Object)signature, (Object)signature);
                if (!signature.isMethod()) continue;
                for (String rdepend : reverseDependencies) {
                    Signature newSignature = signature.forClassName(rdepend);
                    signatureMaps.put((Object)newSignature, (Object)newSignature);
                }
            }
        }
    }

    private Multimap<String, String> processDepends(Map<String, ByteClass> byteClasses) {
        HashMultimap depends = HashMultimap.create();
        Set<String> knownClasses = byteClasses.keySet();
        for (Map.Entry<String, ByteClass> entry : byteClasses.entrySet()) {
            String name = entry.getKey();
            ByteClass clazz = entry.getValue();
            for (String interfaceName : clazz.getInterfaces()) {
                this.addTransitiveDependencies((HashMultimap<String, String>)depends, knownClasses, name, interfaceName);
            }
            this.addTransitiveDependencies((HashMultimap<String, String>)depends, knownClasses, name, clazz.getParent());
        }
        return depends;
    }

    private void addTransitiveDependencies(HashMultimap<String, String> depends, Set<String> knownClasses, String name, String dependency) {
        if (!knownClasses.contains(dependency)) {
            return;
        }
        Set transitiveDependencies = depends.get((Object)dependency);
        if (transitiveDependencies != null) {
            depends.putAll((Object)name, (Iterable)transitiveDependencies);
        }
        depends.put((Object)name, (Object)dependency);
    }

    private Multimap<String, String> processReverseDepends(Multimap<String, String> dependencies) {
        HashMultimap rdepends = HashMultimap.create();
        for (Map.Entry dependency : dependencies.entries()) {
            rdepends.put(dependency.getValue(), dependency.getKey());
        }
        return rdepends;
    }

    private void readClasses(MultiProcessor executor, Map<String, ByteClass> byteClasses, List<Pair<ZipEntry, byte[]>> fileEntries) throws ZipException, IOException, InterruptedException, ExecutionException, MojoFailureException {
        ArrayList classBuffer = Lists.newArrayList();
        ArrayList fileBuffer = Lists.newArrayList();
        final ZipFile zipInput = new ZipFile(this.input);
        for (final ZipEntry zipEntry : Collections.list(zipInput.entries())) {
            if (ByteClass.isClass(zipEntry.getName())) {
                classBuffer.add(executor.submit(new Callable<ByteClass>(){

                    @Override
                    public ByteClass call() throws Exception {
                        return new ByteClass(zipEntry.getName(), zipInput.getInputStream(zipEntry));
                    }
                }));
                continue;
            }
            fileBuffer.add(executor.submit(new Callable<Pair<ZipEntry, byte[]>>(){

                @Override
                public Pair<ZipEntry, byte[]> call() throws Exception {
                    return new ImmutablePair((Object)new ZipEntry(zipEntry), (Object)ByteStreams.toByteArray((InputStream)zipInput.getInputStream(zipEntry)));
                }
            }));
        }
        for (Future future : fileBuffer) {
            fileEntries.add((Pair<ZipEntry, byte[]>)future.get());
        }
        for (Future future : classBuffer) {
            ByteClass clazz = (ByteClass)future.get();
            if ((clazz = byteClasses.put(clazz.getToken(), clazz)) == null) continue;
            throw new MojoFailureException(String.format("Duplicate class definition %s - %s", clazz, future.get()));
        }
        zipInput.close();
    }

    private void reorderEntries(final Map<String, ByteClass> byteClasses) throws WellOrdered.WellOrderedException {
        ArrayList<ByteClass> classBuffer = WellOrdered.process(new ArrayList(), byteClasses.values(), new WellOrdered.AbstractInformer<ByteClass>(){

            @Override
            public void addPrecedingTo(ByteClass token, Collection<? super ByteClass> of) {
                this.addIfFound(token.getParent(), of);
                for (String interfaceName : token.getInterfaces()) {
                    this.addIfFound(interfaceName, of);
                }
            }

            private void addIfFound(String name, Collection<? super ByteClass> of) {
                ByteClass clazz = (ByteClass)byteClasses.get(name);
                if (clazz != null) {
                    of.add(clazz);
                }
            }
        });
        byteClasses.clear();
        for (ByteClass clazz : classBuffer) {
            byteClasses.put(clazz.getToken(), clazz);
        }
    }

    private void verifyOut(File out) throws MojoFailureException {
        if (out != null) {
            if (out.isDirectory()) {
                throw new MojoFailureException(String.format("Cannot write to directory `%s'", out));
            }
            File parent = out.getParentFile();
            if (!parent.isDirectory() && !parent.mkdirs()) {
                throw new MojoFailureException(String.format("Cannot make directory for `%s'", out));
            }
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.uncaught = new ImmutablePair((Object)t, (Object)e);
    }
}

