/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.util;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ProxyVersion {
    private final String name;
    private final String vendor;
    private final String version;

    public ProxyVersion(String name, String vendor, String version) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.vendor = (String)Preconditions.checkNotNull((Object)vendor, (Object)"vendor");
        this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
    }

    public String getName() {
        return this.name;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyVersion that = (ProxyVersion)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.vendor, that.vendor) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.vendor, this.version);
    }

    public String toString() {
        return "ProxyVersion{name='" + this.name + "', vendor='" + this.vendor + "', version='" + this.version + "'}";
    }
}

