/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.proxy.crypto;

import com.google.common.annotations.Beta;
import java.security.PublicKey;
import java.time.Instant;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface KeySigned {
    public PublicKey getSigner();

    public Instant getExpiryTemporal();

    default public boolean hasExpired() {
        return Instant.now().isAfter(this.getExpiryTemporal());
    }

    public @Nullable byte[] getSignature();

    @Beta
    default public boolean isSignatureValid() {
        return false;
    }

    default public byte[] getSalt() {
        return null;
    }
}

