/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.player;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.event.annotation.AwaitingEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

@AwaitingEvent
public final class ServerPreConnectEvent
implements ResultedEvent<ServerResult> {
    private final Player player;
    private final RegisteredServer originalServer;
    private final RegisteredServer previousServer;
    private ServerResult result;

    public ServerPreConnectEvent(Player player, RegisteredServer originalServer) {
        this(player, originalServer, player.getCurrentServer().map(ServerConnection::getServer).orElse(null));
    }

    public ServerPreConnectEvent(Player player, RegisteredServer originalServer, @Nullable RegisteredServer previousServer) {
        this.player = (Player)Preconditions.checkNotNull((Object)player, (Object)"player");
        this.originalServer = (RegisteredServer)Preconditions.checkNotNull((Object)originalServer, (Object)"originalServer");
        this.previousServer = previousServer;
        this.result = ServerResult.allowed(originalServer);
    }

    public Player getPlayer() {
        return this.player;
    }

    @Override
    public ServerResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(ServerResult result) {
        this.result = (ServerResult)Preconditions.checkNotNull((Object)result, (Object)"result");
    }

    public RegisteredServer getOriginalServer() {
        return this.originalServer;
    }

    public @Nullable RegisteredServer getPreviousServer() {
        return this.previousServer;
    }

    public String toString() {
        return "ServerPreConnectEvent{player=" + this.player + ", originalServer=" + this.originalServer + ", result=" + this.result + '}';
    }

    public static class ServerResult
    implements ResultedEvent.Result {
        private static final ServerResult DENIED = new ServerResult(null);
        private final @Nullable RegisteredServer server;

        private ServerResult(@Nullable RegisteredServer server) {
            this.server = server;
        }

        @Override
        public boolean isAllowed() {
            return this.server != null;
        }

        public Optional<RegisteredServer> getServer() {
            return Optional.ofNullable(this.server);
        }

        public String toString() {
            if (this.server != null) {
                return "allowed: connect to " + this.server.getServerInfo().getName();
            }
            return "denied";
        }

        public static ServerResult denied() {
            return DENIED;
        }

        public static ServerResult allowed(RegisteredServer server) {
            Preconditions.checkNotNull((Object)server, (Object)"server");
            return new ServerResult(server);
        }
    }
}

