/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.permission;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.annotation.AwaitingEvent;
import com.velocitypowered.api.permission.PermissionFunction;
import com.velocitypowered.api.permission.PermissionProvider;
import com.velocitypowered.api.permission.PermissionSubject;
import org.checkerframework.checker.nullness.qual.Nullable;

@AwaitingEvent
public final class PermissionsSetupEvent {
    private final PermissionSubject subject;
    private final PermissionProvider defaultProvider;
    private PermissionProvider provider;

    public PermissionsSetupEvent(PermissionSubject subject, PermissionProvider provider) {
        this.subject = (PermissionSubject)Preconditions.checkNotNull((Object)subject, (Object)"subject");
        this.provider = this.defaultProvider = (PermissionProvider)Preconditions.checkNotNull((Object)provider, (Object)"provider");
    }

    public PermissionSubject getSubject() {
        return this.subject;
    }

    public PermissionFunction createFunction(PermissionSubject subject) {
        return this.provider.createFunction(subject);
    }

    public PermissionProvider getProvider() {
        return this.provider;
    }

    public void setProvider(@Nullable PermissionProvider provider) {
        this.provider = provider == null ? this.defaultProvider : provider;
    }

    public String toString() {
        return "PermissionsSetupEvent{subject=" + this.subject + ", defaultProvider=" + this.defaultProvider + ", provider=" + this.provider + '}';
    }
}

