/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.velocitypowered.api.util.UuidUtils;
import java.util.List;
import java.util.UUID;

public final class GameProfile {
    private final UUID id;
    private final String undashedId;
    private final String name;
    private final List<Property> properties;

    public GameProfile(UUID id, String name, List<Property> properties) {
        this((UUID)Preconditions.checkNotNull((Object)id, (Object)"id"), UuidUtils.toUndashed(id), (String)Preconditions.checkNotNull((Object)name, (Object)"name"), (List<Property>)ImmutableList.copyOf(properties));
    }

    public GameProfile(String undashedId, String name, List<Property> properties) {
        this(UuidUtils.fromUndashed((String)Preconditions.checkNotNull((Object)undashedId, (Object)"undashedId")), undashedId, (String)Preconditions.checkNotNull((Object)name, (Object)"name"), (List<Property>)ImmutableList.copyOf(properties));
    }

    private GameProfile(UUID id, String undashedId, String name, List<Property> properties) {
        this.id = id;
        this.undashedId = undashedId;
        this.name = name;
        this.properties = properties;
    }

    public String getUndashedId() {
        return this.undashedId;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public GameProfile withId(UUID id) {
        return new GameProfile((UUID)Preconditions.checkNotNull((Object)id, (Object)"id"), UuidUtils.toUndashed(id), this.name, this.properties);
    }

    public GameProfile withUndashedId(String undashedId) {
        return new GameProfile(UuidUtils.fromUndashed((String)Preconditions.checkNotNull((Object)undashedId, (Object)"undashedId")), undashedId, this.name, this.properties);
    }

    public GameProfile withName(String name) {
        return new GameProfile(this.id, this.undashedId, (String)Preconditions.checkNotNull((Object)name, (Object)"name"), this.properties);
    }

    public GameProfile withProperties(List<Property> properties) {
        return new GameProfile(this.id, this.undashedId, this.name, (List<Property>)ImmutableList.copyOf(properties));
    }

    public GameProfile addProperties(Iterable<Property> properties) {
        return new GameProfile(this.id, this.undashedId, this.name, (List<Property>)ImmutableList.builder().addAll(this.properties).addAll(properties).build());
    }

    public GameProfile addProperty(Property property) {
        return new GameProfile(this.id, this.undashedId, this.name, (List<Property>)ImmutableList.builder().addAll(this.properties).add((Object)property).build());
    }

    public static GameProfile forOfflinePlayer(String username) {
        Preconditions.checkNotNull((Object)username, (Object)"username");
        return new GameProfile(UuidUtils.generateOfflinePlayerUuid(username), username, (List<Property>)ImmutableList.of());
    }

    public String toString() {
        return "GameProfile{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", properties=" + this.properties + '}';
    }

    public static final class Property {
        private final String name;
        private final String value;
        private final String signature;

        public Property(String name, String value, String signature) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
            this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            this.signature = (String)Preconditions.checkNotNull((Object)signature, (Object)"signature");
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getSignature() {
            return this.signature;
        }

        public String toString() {
            return "Property{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", signature='" + this.signature + '\'' + '}';
        }
    }
}

