/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.connection;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.ChannelMessageSink;
import com.velocitypowered.api.proxy.messages.ChannelMessageSource;
import java.io.ByteArrayInputStream;
import java.util.Arrays;

public final class PluginMessageEvent
implements ResultedEvent<ForwardResult> {
    private final ChannelMessageSource source;
    private final ChannelMessageSink target;
    private final ChannelIdentifier identifier;
    private final byte[] data;
    private ForwardResult result;

    public PluginMessageEvent(ChannelMessageSource source, ChannelMessageSink target, ChannelIdentifier identifier, byte[] data) {
        this.source = (ChannelMessageSource)Preconditions.checkNotNull((Object)source, (Object)"source");
        this.target = (ChannelMessageSink)Preconditions.checkNotNull((Object)target, (Object)"target");
        this.identifier = (ChannelIdentifier)Preconditions.checkNotNull((Object)identifier, (Object)"identifier");
        this.data = (byte[])Preconditions.checkNotNull((Object)data, (Object)"data");
        this.result = ForwardResult.forward();
    }

    @Override
    public ForwardResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(ForwardResult result) {
        this.result = (ForwardResult)Preconditions.checkNotNull((Object)result, (Object)"result");
    }

    public ChannelMessageSource getSource() {
        return this.source;
    }

    public ChannelMessageSink getTarget() {
        return this.target;
    }

    public ChannelIdentifier getIdentifier() {
        return this.identifier;
    }

    public byte[] getData() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public ByteArrayInputStream dataAsInputStream() {
        return new ByteArrayInputStream(this.data);
    }

    public ByteArrayDataInput dataAsDataStream() {
        return ByteStreams.newDataInput((byte[])this.data);
    }

    public String toString() {
        return "PluginMessageEvent{source=" + this.source + ", target=" + this.target + ", identifier=" + this.identifier + ", data=" + Arrays.toString(this.data) + ", result=" + this.result + '}';
    }

    public static final class ForwardResult
    implements ResultedEvent.Result {
        private static final ForwardResult ALLOWED = new ForwardResult(true);
        private static final ForwardResult DENIED = new ForwardResult(false);
        private final boolean status;

        private ForwardResult(boolean b) {
            this.status = b;
        }

        @Override
        public boolean isAllowed() {
            return this.status;
        }

        public String toString() {
            return this.status ? "forward to sink" : "handled message at proxy";
        }

        public static ForwardResult forward() {
            return ALLOWED;
        }

        public static ForwardResult handled() {
            return DENIED;
        }
    }
}

