/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.util;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.util.FastUuidSansHyphens;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;

public final class UuidUtils {
    private UuidUtils() {
        throw new AssertionError();
    }

    public static UUID fromUndashed(String string) {
        Objects.requireNonNull(string, "string");
        return FastUuidSansHyphens.parseUuid(string);
    }

    public static String toUndashed(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid, (Object)"uuid");
        return FastUuidSansHyphens.toString(uuid);
    }

    public static UUID generateOfflinePlayerUuid(String username) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(StandardCharsets.UTF_8));
    }
}

