/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;

public final class UuidUtils {
    private UuidUtils() {
        throw new AssertionError();
    }

    public static UUID fromUndashed(String string) {
        Objects.requireNonNull(string, "string");
        Preconditions.checkArgument((string.length() == 32 ? 1 : 0) != 0, (Object)"Length is incorrect");
        return new UUID(Long.parseUnsignedLong(string.substring(0, 16), 16), Long.parseUnsignedLong(string.substring(16), 16));
    }

    public static String toUndashed(UUID uuid) {
        Preconditions.checkNotNull((Object)uuid, (Object)"uuid");
        String msbStr = Long.toHexString(uuid.getMostSignificantBits());
        String lsbStr = Long.toHexString(uuid.getLeastSignificantBits());
        return Strings.padStart((String)msbStr, (int)16, (char)'0') + Strings.padStart((String)lsbStr, (int)16, (char)'0');
    }

    public static UUID generateOfflinePlayerUuid(String username) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(StandardCharsets.UTF_8));
    }
}

