/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.contextmenu;

import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.HtmlImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;

@Tag(value="vaadin-context-menu")
@NpmPackage(value="@vaadin/vaadin-context-menu", version="4.6.1")
@JsModule(value="@vaadin/vaadin-context-menu/src/vaadin-context-menu.js")
@HtmlImport(value="frontend://bower_components/vaadin-context-menu/src/vaadin-context-menu.html")
public abstract class GeneratedVaadinContextMenu<R extends GeneratedVaadinContextMenu<R>>
extends Component
implements HasStyle,
ClickNotifier<R> {
    protected String getSelectorString() {
        return this.getElement().getProperty("selector");
    }

    protected void setSelector(String selector) {
        this.getElement().setProperty("selector", selector == null ? "" : selector);
    }

    @Synchronize(property="opened", value={"opened-changed"})
    protected boolean isOpenedBoolean() {
        return this.getElement().getProperty("opened", false);
    }

    protected String getOpenOnString() {
        return this.getElement().getProperty("openOn");
    }

    protected void setOpenOn(String openOn) {
        this.getElement().setProperty("openOn", openOn == null ? "" : openOn);
    }

    protected JsonObject getListenOnJsonObject() {
        return (JsonObject)this.getElement().getPropertyRaw("listenOn");
    }

    protected void setListenOn(JsonObject listenOn) {
        this.getElement().setPropertyJson("listenOn", (JsonValue)listenOn);
    }

    protected String getCloseOnString() {
        return this.getElement().getProperty("closeOn");
    }

    protected void setCloseOn(String closeOn) {
        this.getElement().setProperty("closeOn", closeOn == null ? "" : closeOn);
    }

    protected void close() {
        this.getElement().callFunction("close", new Serializable[0]);
    }

    protected void open() {
        this.getElement().callFunction("open", new Serializable[0]);
    }

    protected Registration addOpenedChangeListener(ComponentEventListener<OpenedChangeEvent<R>> listener) {
        return this.getElement().addPropertyChangeListener("opened", (PropertyChangeListener & Serializable)event -> listener.onComponentEvent(new OpenedChangeEvent<GeneratedVaadinContextMenu>(this, event.isUserOriginated())));
    }

    public static class OpenedChangeEvent<R extends GeneratedVaadinContextMenu<R>>
    extends ComponentEvent<R> {
        private final boolean opened;

        public OpenedChangeEvent(R source, boolean fromClient) {
            super(source, fromClient);
            this.opened = ((GeneratedVaadinContextMenu)((Object)source)).isOpenedBoolean();
        }

        public boolean isOpened() {
            return this.opened;
        }
    }
}

