/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.Media;
import com.twitter.clientlib.model.VideoAllOfNonPublicMetrics;
import com.twitter.clientlib.model.VideoAllOfOrganicMetrics;
import com.twitter.clientlib.model.VideoAllOfPromotedMetrics;
import com.twitter.clientlib.model.VideoAllOfPublicMetrics;
import com.twitter.clientlib.model.VideoAllOfVariants;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class Video
extends Media {
    public static final String SERIALIZED_NAME_PREVIEW_IMAGE_URL = "preview_image_url";
    @SerializedName(value="preview_image_url")
    private URL previewImageUrl;
    public static final String SERIALIZED_NAME_DURATION_MS = "duration_ms";
    @SerializedName(value="duration_ms")
    private Integer durationMs;
    public static final String SERIALIZED_NAME_VARIANTS = "variants";
    @SerializedName(value="variants")
    private List<VideoAllOfVariants> variants = null;
    public static final String SERIALIZED_NAME_PUBLIC_METRICS = "public_metrics";
    @SerializedName(value="public_metrics")
    private VideoAllOfPublicMetrics publicMetrics;
    public static final String SERIALIZED_NAME_NON_PUBLIC_METRICS = "non_public_metrics";
    @SerializedName(value="non_public_metrics")
    private VideoAllOfNonPublicMetrics nonPublicMetrics;
    public static final String SERIALIZED_NAME_ORGANIC_METRICS = "organic_metrics";
    @SerializedName(value="organic_metrics")
    private VideoAllOfOrganicMetrics organicMetrics;
    public static final String SERIALIZED_NAME_PROMOTED_METRICS = "promoted_metrics";
    @SerializedName(value="promoted_metrics")
    private VideoAllOfPromotedMetrics promotedMetrics;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Video() {
        this.type = this.getClass().getSimpleName();
    }

    public Video previewImageUrl(URL previewImageUrl) {
        this.previewImageUrl = previewImageUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public URL getPreviewImageUrl() {
        return this.previewImageUrl;
    }

    public void setPreviewImageUrl(URL previewImageUrl) {
        this.previewImageUrl = previewImageUrl;
    }

    public Video durationMs(Integer durationMs) {
        this.durationMs = durationMs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Integer getDurationMs() {
        return this.durationMs;
    }

    public void setDurationMs(Integer durationMs) {
        this.durationMs = durationMs;
    }

    public Video variants(List<VideoAllOfVariants> variants) {
        this.variants = variants;
        return this;
    }

    public Video addVariantsItem(VideoAllOfVariants variantsItem) {
        if (this.variants == null) {
            this.variants = new ArrayList<VideoAllOfVariants>();
        }
        this.variants.add(variantsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of all available variants of the media")
    public List<VideoAllOfVariants> getVariants() {
        return this.variants;
    }

    public void setVariants(List<VideoAllOfVariants> variants) {
        this.variants = variants;
    }

    public Video publicMetrics(VideoAllOfPublicMetrics publicMetrics) {
        this.publicMetrics = publicMetrics;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public VideoAllOfPublicMetrics getPublicMetrics() {
        return this.publicMetrics;
    }

    public void setPublicMetrics(VideoAllOfPublicMetrics publicMetrics) {
        this.publicMetrics = publicMetrics;
    }

    public Video nonPublicMetrics(VideoAllOfNonPublicMetrics nonPublicMetrics) {
        this.nonPublicMetrics = nonPublicMetrics;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public VideoAllOfNonPublicMetrics getNonPublicMetrics() {
        return this.nonPublicMetrics;
    }

    public void setNonPublicMetrics(VideoAllOfNonPublicMetrics nonPublicMetrics) {
        this.nonPublicMetrics = nonPublicMetrics;
    }

    public Video organicMetrics(VideoAllOfOrganicMetrics organicMetrics) {
        this.organicMetrics = organicMetrics;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public VideoAllOfOrganicMetrics getOrganicMetrics() {
        return this.organicMetrics;
    }

    public void setOrganicMetrics(VideoAllOfOrganicMetrics organicMetrics) {
        this.organicMetrics = organicMetrics;
    }

    public Video promotedMetrics(VideoAllOfPromotedMetrics promotedMetrics) {
        this.promotedMetrics = promotedMetrics;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public VideoAllOfPromotedMetrics getPromotedMetrics() {
        return this.promotedMetrics;
    }

    public void setPromotedMetrics(VideoAllOfPromotedMetrics promotedMetrics) {
        this.promotedMetrics = promotedMetrics;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Video video = (Video)o;
        return Objects.equals(this.previewImageUrl, video.previewImageUrl) && Objects.equals(this.durationMs, video.durationMs) && Objects.equals(this.variants, video.variants) && Objects.equals(this.publicMetrics, video.publicMetrics) && Objects.equals(this.nonPublicMetrics, video.nonPublicMetrics) && Objects.equals(this.organicMetrics, video.organicMetrics) && Objects.equals(this.promotedMetrics, video.promotedMetrics) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.previewImageUrl, this.durationMs, this.variants, this.publicMetrics, this.nonPublicMetrics, this.organicMetrics, this.promotedMetrics, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Video {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    previewImageUrl: ").append(this.toIndentedString(this.previewImageUrl)).append("\n");
        sb.append("    durationMs: ").append(this.toIndentedString(this.durationMs)).append("\n");
        sb.append("    variants: ").append(this.toIndentedString(this.variants)).append("\n");
        sb.append("    publicMetrics: ").append(this.toIndentedString(this.publicMetrics)).append("\n");
        sb.append("    nonPublicMetrics: ").append(this.toIndentedString(this.nonPublicMetrics)).append("\n");
        sb.append("    organicMetrics: ").append(this.toIndentedString(this.organicMetrics)).append("\n");
        sb.append("    promotedMetrics: ").append(this.toIndentedString(this.promotedMetrics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
    }

    public static Video fromJson(String jsonString) throws IOException {
        return (Video)JSON.getGson().fromJson(jsonString, Video.class);
    }

    @Override
    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add("type");
        openapiFields.add("media_key");
        openapiFields.add("height");
        openapiFields.add("width");
        openapiFields.add(SERIALIZED_NAME_PREVIEW_IMAGE_URL);
        openapiFields.add(SERIALIZED_NAME_DURATION_MS);
        openapiFields.add(SERIALIZED_NAME_VARIANTS);
        openapiFields.add(SERIALIZED_NAME_PUBLIC_METRICS);
        openapiFields.add(SERIALIZED_NAME_NON_PUBLIC_METRICS);
        openapiFields.add(SERIALIZED_NAME_ORGANIC_METRICS);
        openapiFields.add(SERIALIZED_NAME_PROMOTED_METRICS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add("type");
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Video.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Video.class));
            return new TypeAdapter<Video>(){

                public void write(JsonWriter out, Video value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Video read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Video.validateJsonObject(jsonObj);
                    return (Video)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

