/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Organic nonpublic engagement metrics for the Tweet at the time of the request.")
public class TweetOrganicMetrics {
    public static final String SERIALIZED_NAME_IMPRESSION_COUNT = "impression_count";
    @SerializedName(value="impression_count")
    private Integer impressionCount;
    public static final String SERIALIZED_NAME_RETWEET_COUNT = "retweet_count";
    @SerializedName(value="retweet_count")
    private Integer retweetCount;
    public static final String SERIALIZED_NAME_REPLY_COUNT = "reply_count";
    @SerializedName(value="reply_count")
    private Integer replyCount;
    public static final String SERIALIZED_NAME_LIKE_COUNT = "like_count";
    @SerializedName(value="like_count")
    private Integer likeCount;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TweetOrganicMetrics impressionCount(Integer impressionCount) {
        this.impressionCount = impressionCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of times this Tweet has been viewed.")
    public Integer getImpressionCount() {
        return this.impressionCount;
    }

    public void setImpressionCount(Integer impressionCount) {
        this.impressionCount = impressionCount;
    }

    public TweetOrganicMetrics retweetCount(Integer retweetCount) {
        this.retweetCount = retweetCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of times this Tweet has been Retweeted.")
    public Integer getRetweetCount() {
        return this.retweetCount;
    }

    public void setRetweetCount(Integer retweetCount) {
        this.retweetCount = retweetCount;
    }

    public TweetOrganicMetrics replyCount(Integer replyCount) {
        this.replyCount = replyCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of times this Tweet has been replied to.")
    public Integer getReplyCount() {
        return this.replyCount;
    }

    public void setReplyCount(Integer replyCount) {
        this.replyCount = replyCount;
    }

    public TweetOrganicMetrics likeCount(Integer likeCount) {
        this.likeCount = likeCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of times this Tweet has been liked.")
    public Integer getLikeCount() {
        return this.likeCount;
    }

    public void setLikeCount(Integer likeCount) {
        this.likeCount = likeCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TweetOrganicMetrics tweetOrganicMetrics = (TweetOrganicMetrics)o;
        return Objects.equals(this.impressionCount, tweetOrganicMetrics.impressionCount) && Objects.equals(this.retweetCount, tweetOrganicMetrics.retweetCount) && Objects.equals(this.replyCount, tweetOrganicMetrics.replyCount) && Objects.equals(this.likeCount, tweetOrganicMetrics.likeCount);
    }

    public int hashCode() {
        return Objects.hash(this.impressionCount, this.retweetCount, this.replyCount, this.likeCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TweetOrganicMetrics {\n");
        sb.append("    impressionCount: ").append(this.toIndentedString(this.impressionCount)).append("\n");
        sb.append("    retweetCount: ").append(this.toIndentedString(this.retweetCount)).append("\n");
        sb.append("    replyCount: ").append(this.toIndentedString(this.replyCount)).append("\n");
        sb.append("    likeCount: ").append(this.toIndentedString(this.likeCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
    }

    public static TweetOrganicMetrics fromJson(String jsonString) throws IOException {
        return (TweetOrganicMetrics)JSON.getGson().fromJson(jsonString, TweetOrganicMetrics.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_IMPRESSION_COUNT);
        openapiFields.add(SERIALIZED_NAME_RETWEET_COUNT);
        openapiFields.add(SERIALIZED_NAME_REPLY_COUNT);
        openapiFields.add(SERIALIZED_NAME_LIKE_COUNT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TweetOrganicMetrics.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TweetOrganicMetrics.class));
            return new TypeAdapter<TweetOrganicMetrics>(){

                public void write(JsonWriter out, TweetOrganicMetrics value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TweetOrganicMetrics read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TweetOrganicMetrics.validateJsonObject(jsonObj);
                    return (TweetOrganicMetrics)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

