/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Tweet information of the Tweet being replied to.")
public class CreateTweetRequestReply {
    public static final String SERIALIZED_NAME_IN_REPLY_TO_TWEET_ID = "in_reply_to_tweet_id";
    @SerializedName(value="in_reply_to_tweet_id")
    private String inReplyToTweetId;
    public static final String SERIALIZED_NAME_EXCLUDE_REPLY_USER_IDS = "exclude_reply_user_ids";
    @SerializedName(value="exclude_reply_user_ids")
    private List<String> excludeReplyUserIds = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CreateTweetRequestReply inReplyToTweetId(String inReplyToTweetId) {
        this.inReplyToTweetId = inReplyToTweetId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1346889436626259968", value="Unique identifier of this Tweet. This is returned as a string in order to avoid complications with languages and tools that cannot handle large integers.")
    public String getInReplyToTweetId() {
        return this.inReplyToTweetId;
    }

    public void setInReplyToTweetId(String inReplyToTweetId) {
        this.inReplyToTweetId = inReplyToTweetId;
    }

    public CreateTweetRequestReply excludeReplyUserIds(List<String> excludeReplyUserIds) {
        this.excludeReplyUserIds = excludeReplyUserIds;
        return this;
    }

    public CreateTweetRequestReply addExcludeReplyUserIdsItem(String excludeReplyUserIdsItem) {
        if (this.excludeReplyUserIds == null) {
            this.excludeReplyUserIds = new ArrayList<String>();
        }
        this.excludeReplyUserIds.add(excludeReplyUserIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of User Ids to be excluded from the reply Tweet.")
    public List<String> getExcludeReplyUserIds() {
        return this.excludeReplyUserIds;
    }

    public void setExcludeReplyUserIds(List<String> excludeReplyUserIds) {
        this.excludeReplyUserIds = excludeReplyUserIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTweetRequestReply createTweetRequestReply = (CreateTweetRequestReply)o;
        return Objects.equals(this.inReplyToTweetId, createTweetRequestReply.inReplyToTweetId) && Objects.equals(this.excludeReplyUserIds, createTweetRequestReply.excludeReplyUserIds);
    }

    public int hashCode() {
        return Objects.hash(this.inReplyToTweetId, this.excludeReplyUserIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateTweetRequestReply {\n");
        sb.append("    inReplyToTweetId: ").append(this.toIndentedString(this.inReplyToTweetId)).append("\n");
        sb.append("    excludeReplyUserIds: ").append(this.toIndentedString(this.excludeReplyUserIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj.get(SERIALIZED_NAME_IN_REPLY_TO_TWEET_ID) != null && !jsonObj.get(SERIALIZED_NAME_IN_REPLY_TO_TWEET_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `in_reply_to_tweet_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IN_REPLY_TO_TWEET_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXCLUDE_REPLY_USER_IDS) != null && !jsonObj.get(SERIALIZED_NAME_EXCLUDE_REPLY_USER_IDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `exclude_reply_user_ids` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXCLUDE_REPLY_USER_IDS).toString()));
        }
    }

    public static CreateTweetRequestReply fromJson(String jsonString) throws IOException {
        return (CreateTweetRequestReply)JSON.getGson().fromJson(jsonString, CreateTweetRequestReply.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_IN_REPLY_TO_TWEET_ID);
        openapiFields.add(SERIALIZED_NAME_EXCLUDE_REPLY_USER_IDS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CreateTweetRequestReply.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CreateTweetRequestReply.class));
            return new TypeAdapter<CreateTweetRequestReply>(){

                public void write(JsonWriter out, CreateTweetRequestReply value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CreateTweetRequestReply read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    CreateTweetRequestReply.validateJsonObject(jsonObj);
                    return (CreateTweetRequestReply)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

