/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.api;

import com.github.scribejava.core.model.OAuth2AccessToken;
import com.twitter.clientlib.ApiClient;
import com.twitter.clientlib.ApiClientCallback;
import com.twitter.clientlib.ApiException;
import com.twitter.clientlib.TwitterCredentialsBearer;
import com.twitter.clientlib.TwitterCredentialsOAuth2;
import com.twitter.clientlib.api.BookmarksApi;
import com.twitter.clientlib.api.ComplianceApi;
import com.twitter.clientlib.api.GeneralApi;
import com.twitter.clientlib.api.ListsApi;
import com.twitter.clientlib.api.SpacesApi;
import com.twitter.clientlib.api.TweetsApi;
import com.twitter.clientlib.api.UsersApi;

public class TwitterApi {
    private final BookmarksApi bookmarks = new BookmarksApi();
    private final ComplianceApi compliance = new ComplianceApi();
    private final GeneralApi general = new GeneralApi();
    private final ListsApi lists = new ListsApi();
    private final SpacesApi spaces = new SpacesApi();
    private final TweetsApi tweets = new TweetsApi();
    private final UsersApi users = new UsersApi();
    private ApiClient localVarApiClient = new ApiClient();

    public TwitterApi() {
        this.init();
    }

    public TwitterApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
        this.init();
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public void setTwitterCredentials(TwitterCredentialsBearer credentials) {
        this.localVarApiClient.setTwitterCredentials(credentials);
    }

    public void setTwitterCredentials(TwitterCredentialsOAuth2 credentials) {
        this.localVarApiClient.setTwitterCredentials(credentials);
    }

    private void init() {
        String basePath = System.getenv("TWITTER_API_BASE_PATH");
        this.localVarApiClient.setBasePath(basePath != null ? basePath : "https://api.twitter.com");
        this.initApis();
    }

    private void initApis() {
        this.bookmarks.setClient(this.localVarApiClient);
        this.compliance.setClient(this.localVarApiClient);
        this.general.setClient(this.localVarApiClient);
        this.lists.setClient(this.localVarApiClient);
        this.spaces.setClient(this.localVarApiClient);
        this.tweets.setClient(this.localVarApiClient);
        this.users.setClient(this.localVarApiClient);
    }

    public BookmarksApi bookmarks() {
        return this.bookmarks;
    }

    public ComplianceApi compliance() {
        return this.compliance;
    }

    public GeneralApi general() {
        return this.general;
    }

    public ListsApi lists() {
        return this.lists;
    }

    public SpacesApi spaces() {
        return this.spaces;
    }

    public TweetsApi tweets() {
        return this.tweets;
    }

    public UsersApi users() {
        return this.users;
    }

    public OAuth2AccessToken refreshToken() throws ApiException {
        return this.localVarApiClient.refreshToken();
    }

    public void addCallback(ApiClientCallback toAdd) {
        this.localVarApiClient.addCallback(toAdd);
    }
}

