/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.UserEntities;
import com.twitter.clientlib.model.UserPublicMetrics;
import com.twitter.clientlib.model.UserWithheld;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="The Twitter User object")
public class User {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_USERNAME = "username";
    @SerializedName(value="username")
    private String username;
    public static final String SERIALIZED_NAME_PROTECTED = "protected";
    @SerializedName(value="protected")
    private Boolean _protected;
    public static final String SERIALIZED_NAME_VERIFIED = "verified";
    @SerializedName(value="verified")
    private Boolean verified;
    public static final String SERIALIZED_NAME_WITHHELD = "withheld";
    @SerializedName(value="withheld")
    private UserWithheld withheld;
    public static final String SERIALIZED_NAME_PROFILE_IMAGE_URL = "profile_image_url";
    @SerializedName(value="profile_image_url")
    private URI profileImageUrl;
    public static final String SERIALIZED_NAME_LOCATION = "location";
    @SerializedName(value="location")
    private String location;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private String url;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ENTITIES = "entities";
    @SerializedName(value="entities")
    private UserEntities entities;
    public static final String SERIALIZED_NAME_PINNED_TWEET_ID = "pinned_tweet_id";
    @SerializedName(value="pinned_tweet_id")
    private String pinnedTweetId;
    public static final String SERIALIZED_NAME_PUBLIC_METRICS = "public_metrics";
    @SerializedName(value="public_metrics")
    private UserPublicMetrics publicMetrics;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public User id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2244994945", required=true, value="Unique identifier of this User. This is returned as a string in order to avoid complications with languages and tools that cannot handle large integers.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public User createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Creation time of this user.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public User name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The friendly name of this user, as shown on their profile.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public User username(String username) {
        this.username = username;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The Twitter handle (screen name) of this user.")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public User _protected(Boolean _protected) {
        this._protected = _protected;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if this user has chosen to protect their Tweets (in other words, if this user's Tweets are private).")
    public Boolean getProtected() {
        return this._protected;
    }

    public void setProtected(Boolean _protected) {
        this._protected = _protected;
    }

    public User verified(Boolean verified) {
        this.verified = verified;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicate if this user is a verified Twitter User.")
    public Boolean getVerified() {
        return this.verified;
    }

    public void setVerified(Boolean verified) {
        this.verified = verified;
    }

    public User withheld(UserWithheld withheld) {
        this.withheld = withheld;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UserWithheld getWithheld() {
        return this.withheld;
    }

    public void setWithheld(UserWithheld withheld) {
        this.withheld = withheld;
    }

    public User profileImageUrl(URI profileImageUrl) {
        this.profileImageUrl = profileImageUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL to the profile image for this user.")
    public URI getProfileImageUrl() {
        return this.profileImageUrl;
    }

    public void setProfileImageUrl(URI profileImageUrl) {
        this.profileImageUrl = profileImageUrl;
    }

    public User location(String location) {
        this.location = location;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The location specified in the user's profile, if the user provided one. As this is a freeform value, it may not indicate a valid location, but it may be fuzzily evaluated when performing searches with location queries.")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public User url(String url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL specified in the user's profile.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public User description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The text of this user's profile description (also known as bio), if the user provided one.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public User entities(UserEntities entities) {
        this.entities = entities;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UserEntities getEntities() {
        return this.entities;
    }

    public void setEntities(UserEntities entities) {
        this.entities = entities;
    }

    public User pinnedTweetId(String pinnedTweetId) {
        this.pinnedTweetId = pinnedTweetId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1346889436626259968", value="Unique identifier of this Tweet. This is returned as a string in order to avoid complications with languages and tools that cannot handle large integers.")
    public String getPinnedTweetId() {
        return this.pinnedTweetId;
    }

    public void setPinnedTweetId(String pinnedTweetId) {
        this.pinnedTweetId = pinnedTweetId;
    }

    public User publicMetrics(UserPublicMetrics publicMetrics) {
        this.publicMetrics = publicMetrics;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public UserPublicMetrics getPublicMetrics() {
        return this.publicMetrics;
    }

    public void setPublicMetrics(UserPublicMetrics publicMetrics) {
        this.publicMetrics = publicMetrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.id, user.id) && Objects.equals(this.createdAt, user.createdAt) && Objects.equals(this.name, user.name) && Objects.equals(this.username, user.username) && Objects.equals(this._protected, user._protected) && Objects.equals(this.verified, user.verified) && Objects.equals(this.withheld, user.withheld) && Objects.equals(this.profileImageUrl, user.profileImageUrl) && Objects.equals(this.location, user.location) && Objects.equals(this.url, user.url) && Objects.equals(this.description, user.description) && Objects.equals(this.entities, user.entities) && Objects.equals(this.pinnedTweetId, user.pinnedTweetId) && Objects.equals(this.publicMetrics, user.publicMetrics);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.createdAt, this.name, this.username, this._protected, this.verified, this.withheld, this.profileImageUrl, this.location, this.url, this.description, this.entities, this.pinnedTweetId, this.publicMetrics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class User {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    _protected: ").append(this.toIndentedString(this._protected)).append("\n");
        sb.append("    verified: ").append(this.toIndentedString(this.verified)).append("\n");
        sb.append("    withheld: ").append(this.toIndentedString(this.withheld)).append("\n");
        sb.append("    profileImageUrl: ").append(this.toIndentedString(this.profileImageUrl)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    entities: ").append(this.toIndentedString(this.entities)).append("\n");
        sb.append("    pinnedTweetId: ").append(this.toIndentedString(this.pinnedTweetId)).append("\n");
        sb.append("    publicMetrics: ").append(this.toIndentedString(this.publicMetrics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in User is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `User` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_WITHHELD) != null) {
            UserWithheld.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_WITHHELD));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ENTITIES) != null) {
            UserEntities.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ENTITIES));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PUBLIC_METRICS) != null) {
            UserPublicMetrics.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PUBLIC_METRICS));
        }
    }

    public static User fromJson(String jsonString) throws IOException {
        return (User)JSON.getGson().fromJson(jsonString, User.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_USERNAME);
        openapiFields.add(SERIALIZED_NAME_PROTECTED);
        openapiFields.add(SERIALIZED_NAME_VERIFIED);
        openapiFields.add(SERIALIZED_NAME_WITHHELD);
        openapiFields.add(SERIALIZED_NAME_PROFILE_IMAGE_URL);
        openapiFields.add(SERIALIZED_NAME_LOCATION);
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiFields.add(SERIALIZED_NAME_DESCRIPTION);
        openapiFields.add(SERIALIZED_NAME_ENTITIES);
        openapiFields.add(SERIALIZED_NAME_PINNED_TWEET_ID);
        openapiFields.add(SERIALIZED_NAME_PUBLIC_METRICS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_USERNAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!User.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(User.class));
            return new TypeAdapter<User>(){

                public void write(JsonWriter out, User value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public User read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    User.validateJsonObject(jsonObj);
                    return (User)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

