/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.ContextAnnotation;
import com.twitter.clientlib.model.FullTextEntities;
import com.twitter.clientlib.model.ReplySettings;
import com.twitter.clientlib.model.TweetAttachments;
import com.twitter.clientlib.model.TweetGeo;
import com.twitter.clientlib.model.TweetNonPublicMetrics;
import com.twitter.clientlib.model.TweetOrganicMetrics;
import com.twitter.clientlib.model.TweetPromotedMetrics;
import com.twitter.clientlib.model.TweetPublicMetrics;
import com.twitter.clientlib.model.TweetReferencedTweets;
import com.twitter.clientlib.model.TweetWithheld;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Tweet {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_TEXT = "text";
    @SerializedName(value="text")
    private String text;
    public static final String SERIALIZED_NAME_AUTHOR_ID = "author_id";
    @SerializedName(value="author_id")
    private String authorId;
    public static final String SERIALIZED_NAME_IN_REPLY_TO_USER_ID = "in_reply_to_user_id";
    @SerializedName(value="in_reply_to_user_id")
    private String inReplyToUserId;
    public static final String SERIALIZED_NAME_CONVERSATION_ID = "conversation_id";
    @SerializedName(value="conversation_id")
    private String conversationId;
    public static final String SERIALIZED_NAME_REPLY_SETTINGS = "reply_settings";
    @SerializedName(value="reply_settings")
    private ReplySettings replySettings;
    public static final String SERIALIZED_NAME_REFERENCED_TWEETS = "referenced_tweets";
    @SerializedName(value="referenced_tweets")
    private List<TweetReferencedTweets> referencedTweets = null;
    public static final String SERIALIZED_NAME_ATTACHMENTS = "attachments";
    @SerializedName(value="attachments")
    private TweetAttachments attachments;
    public static final String SERIALIZED_NAME_CONTEXT_ANNOTATIONS = "context_annotations";
    @SerializedName(value="context_annotations")
    private List<ContextAnnotation> contextAnnotations = null;
    public static final String SERIALIZED_NAME_WITHHELD = "withheld";
    @SerializedName(value="withheld")
    private TweetWithheld withheld;
    public static final String SERIALIZED_NAME_GEO = "geo";
    @SerializedName(value="geo")
    private TweetGeo geo;
    public static final String SERIALIZED_NAME_ENTITIES = "entities";
    @SerializedName(value="entities")
    private FullTextEntities entities;
    public static final String SERIALIZED_NAME_PUBLIC_METRICS = "public_metrics";
    @SerializedName(value="public_metrics")
    private TweetPublicMetrics publicMetrics;
    public static final String SERIALIZED_NAME_POSSIBLY_SENSITIVE = "possibly_sensitive";
    @SerializedName(value="possibly_sensitive")
    private Boolean possiblySensitive;
    public static final String SERIALIZED_NAME_LANG = "lang";
    @SerializedName(value="lang")
    private String lang;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private String source;
    public static final String SERIALIZED_NAME_NON_PUBLIC_METRICS = "non_public_metrics";
    @SerializedName(value="non_public_metrics")
    private TweetNonPublicMetrics nonPublicMetrics;
    public static final String SERIALIZED_NAME_PROMOTED_METRICS = "promoted_metrics";
    @SerializedName(value="promoted_metrics")
    private TweetPromotedMetrics promotedMetrics;
    public static final String SERIALIZED_NAME_ORGANIC_METRICS = "organic_metrics";
    @SerializedName(value="organic_metrics")
    private TweetOrganicMetrics organicMetrics;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Tweet id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1346889436626259968", required=true, value="Unique identifier of this Tweet. This is returned as a string in order to avoid complications with languages and tools that cannot handle large integers.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Tweet createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2021-01-06T18:40:40Z", value="Creation time of the Tweet.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Tweet text(String text) {
        this.text = text;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="Learn how to use the user Tweet timeline and user mention timeline endpoints in the Twitter API v2 to explore Tweet\\u2026 https://t.co/56a0vZUx7i", required=true, value="The content of the Tweet.")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Tweet authorId(String authorId) {
        this.authorId = authorId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2244994945", value="Unique identifier of this User. This is returned as a string in order to avoid complications with languages and tools that cannot handle large integers.")
    public String getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(String authorId) {
        this.authorId = authorId;
    }

    public Tweet inReplyToUserId(String inReplyToUserId) {
        this.inReplyToUserId = inReplyToUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2244994945", value="Unique identifier of this User. This is returned as a string in order to avoid complications with languages and tools that cannot handle large integers.")
    public String getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    public void setInReplyToUserId(String inReplyToUserId) {
        this.inReplyToUserId = inReplyToUserId;
    }

    public Tweet conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1346889436626259968", value="Unique identifier of this Tweet. This is returned as a string in order to avoid complications with languages and tools that cannot handle large integers.")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public Tweet replySettings(ReplySettings replySettings) {
        this.replySettings = replySettings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ReplySettings getReplySettings() {
        return this.replySettings;
    }

    public void setReplySettings(ReplySettings replySettings) {
        this.replySettings = replySettings;
    }

    public Tweet referencedTweets(List<TweetReferencedTweets> referencedTweets) {
        this.referencedTweets = referencedTweets;
        return this;
    }

    public Tweet addReferencedTweetsItem(TweetReferencedTweets referencedTweetsItem) {
        if (this.referencedTweets == null) {
            this.referencedTweets = new ArrayList<TweetReferencedTweets>();
        }
        this.referencedTweets.add(referencedTweetsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of Tweets this Tweet refers to. For example, if the parent Tweet is a Retweet, a Quoted Tweet or a Reply, it will include the related Tweet referenced to by its parent.")
    public List<TweetReferencedTweets> getReferencedTweets() {
        return this.referencedTweets;
    }

    public void setReferencedTweets(List<TweetReferencedTweets> referencedTweets) {
        this.referencedTweets = referencedTweets;
    }

    public Tweet attachments(TweetAttachments attachments) {
        this.attachments = attachments;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TweetAttachments getAttachments() {
        return this.attachments;
    }

    public void setAttachments(TweetAttachments attachments) {
        this.attachments = attachments;
    }

    public Tweet contextAnnotations(List<ContextAnnotation> contextAnnotations) {
        this.contextAnnotations = contextAnnotations;
        return this;
    }

    public Tweet addContextAnnotationsItem(ContextAnnotation contextAnnotationsItem) {
        if (this.contextAnnotations == null) {
            this.contextAnnotations = new ArrayList<ContextAnnotation>();
        }
        this.contextAnnotations.add(contextAnnotationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<ContextAnnotation> getContextAnnotations() {
        return this.contextAnnotations;
    }

    public void setContextAnnotations(List<ContextAnnotation> contextAnnotations) {
        this.contextAnnotations = contextAnnotations;
    }

    public Tweet withheld(TweetWithheld withheld) {
        this.withheld = withheld;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TweetWithheld getWithheld() {
        return this.withheld;
    }

    public void setWithheld(TweetWithheld withheld) {
        this.withheld = withheld;
    }

    public Tweet geo(TweetGeo geo) {
        this.geo = geo;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TweetGeo getGeo() {
        return this.geo;
    }

    public void setGeo(TweetGeo geo) {
        this.geo = geo;
    }

    public Tweet entities(FullTextEntities entities) {
        this.entities = entities;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FullTextEntities getEntities() {
        return this.entities;
    }

    public void setEntities(FullTextEntities entities) {
        this.entities = entities;
    }

    public Tweet publicMetrics(TweetPublicMetrics publicMetrics) {
        this.publicMetrics = publicMetrics;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TweetPublicMetrics getPublicMetrics() {
        return this.publicMetrics;
    }

    public void setPublicMetrics(TweetPublicMetrics publicMetrics) {
        this.publicMetrics = publicMetrics;
    }

    public Tweet possiblySensitive(Boolean possiblySensitive) {
        this.possiblySensitive = possiblySensitive;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="false", value="Indicates if this Tweet contains URLs marked as sensitive, for example content suitable for mature audiences.")
    public Boolean getPossiblySensitive() {
        return this.possiblySensitive;
    }

    public void setPossiblySensitive(Boolean possiblySensitive) {
        this.possiblySensitive = possiblySensitive;
    }

    public Tweet lang(String lang) {
        this.lang = lang;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="en", value="Language of the Tweet, if detected by Twitter. Returned as a BCP47 language tag.")
    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Tweet source(String source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the app the user Tweeted from.")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Tweet nonPublicMetrics(TweetNonPublicMetrics nonPublicMetrics) {
        this.nonPublicMetrics = nonPublicMetrics;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TweetNonPublicMetrics getNonPublicMetrics() {
        return this.nonPublicMetrics;
    }

    public void setNonPublicMetrics(TweetNonPublicMetrics nonPublicMetrics) {
        this.nonPublicMetrics = nonPublicMetrics;
    }

    public Tweet promotedMetrics(TweetPromotedMetrics promotedMetrics) {
        this.promotedMetrics = promotedMetrics;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TweetPromotedMetrics getPromotedMetrics() {
        return this.promotedMetrics;
    }

    public void setPromotedMetrics(TweetPromotedMetrics promotedMetrics) {
        this.promotedMetrics = promotedMetrics;
    }

    public Tweet organicMetrics(TweetOrganicMetrics organicMetrics) {
        this.organicMetrics = organicMetrics;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public TweetOrganicMetrics getOrganicMetrics() {
        return this.organicMetrics;
    }

    public void setOrganicMetrics(TweetOrganicMetrics organicMetrics) {
        this.organicMetrics = organicMetrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tweet tweet = (Tweet)o;
        return Objects.equals(this.id, tweet.id) && Objects.equals(this.createdAt, tweet.createdAt) && Objects.equals(this.text, tweet.text) && Objects.equals(this.authorId, tweet.authorId) && Objects.equals(this.inReplyToUserId, tweet.inReplyToUserId) && Objects.equals(this.conversationId, tweet.conversationId) && Objects.equals((Object)this.replySettings, (Object)tweet.replySettings) && Objects.equals(this.referencedTweets, tweet.referencedTweets) && Objects.equals(this.attachments, tweet.attachments) && Objects.equals(this.contextAnnotations, tweet.contextAnnotations) && Objects.equals(this.withheld, tweet.withheld) && Objects.equals(this.geo, tweet.geo) && Objects.equals(this.entities, tweet.entities) && Objects.equals(this.publicMetrics, tweet.publicMetrics) && Objects.equals(this.possiblySensitive, tweet.possiblySensitive) && Objects.equals(this.lang, tweet.lang) && Objects.equals(this.source, tweet.source) && Objects.equals(this.nonPublicMetrics, tweet.nonPublicMetrics) && Objects.equals(this.promotedMetrics, tweet.promotedMetrics) && Objects.equals(this.organicMetrics, tweet.organicMetrics);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdAt, this.text, this.authorId, this.inReplyToUserId, this.conversationId, this.replySettings, this.referencedTweets, this.attachments, this.contextAnnotations, this.withheld, this.geo, this.entities, this.publicMetrics, this.possiblySensitive, this.lang, this.source, this.nonPublicMetrics, this.promotedMetrics, this.organicMetrics});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Tweet {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    authorId: ").append(this.toIndentedString(this.authorId)).append("\n");
        sb.append("    inReplyToUserId: ").append(this.toIndentedString(this.inReplyToUserId)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    replySettings: ").append(this.toIndentedString((Object)this.replySettings)).append("\n");
        sb.append("    referencedTweets: ").append(this.toIndentedString(this.referencedTweets)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    contextAnnotations: ").append(this.toIndentedString(this.contextAnnotations)).append("\n");
        sb.append("    withheld: ").append(this.toIndentedString(this.withheld)).append("\n");
        sb.append("    geo: ").append(this.toIndentedString(this.geo)).append("\n");
        sb.append("    entities: ").append(this.toIndentedString(this.entities)).append("\n");
        sb.append("    publicMetrics: ").append(this.toIndentedString(this.publicMetrics)).append("\n");
        sb.append("    possiblySensitive: ").append(this.toIndentedString(this.possiblySensitive)).append("\n");
        sb.append("    lang: ").append(this.toIndentedString(this.lang)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    nonPublicMetrics: ").append(this.toIndentedString(this.nonPublicMetrics)).append("\n");
        sb.append("    promotedMetrics: ").append(this.toIndentedString(this.promotedMetrics)).append("\n");
        sb.append("    organicMetrics: ").append(this.toIndentedString(this.organicMetrics)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraycontextAnnotations;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Tweet is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Tweet` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        JsonArray jsonArrayreferencedTweets = jsonObj.getAsJsonArray(SERIALIZED_NAME_REFERENCED_TWEETS);
        if (jsonArrayreferencedTweets != null) {
            for (int i = 0; i < jsonArrayreferencedTweets.size(); ++i) {
                TweetReferencedTweets.validateJsonObject(jsonArrayreferencedTweets.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ATTACHMENTS) != null) {
            TweetAttachments.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ATTACHMENTS));
        }
        if ((jsonArraycontextAnnotations = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONTEXT_ANNOTATIONS)) != null) {
            for (int i = 0; i < jsonArraycontextAnnotations.size(); ++i) {
                ContextAnnotation.validateJsonObject(jsonArraycontextAnnotations.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_WITHHELD) != null) {
            TweetWithheld.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_WITHHELD));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_GEO) != null) {
            TweetGeo.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_GEO));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ENTITIES) != null) {
            FullTextEntities.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ENTITIES));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PUBLIC_METRICS) != null) {
            TweetPublicMetrics.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PUBLIC_METRICS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_NON_PUBLIC_METRICS) != null) {
            TweetNonPublicMetrics.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NON_PUBLIC_METRICS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_PROMOTED_METRICS) != null) {
            TweetPromotedMetrics.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PROMOTED_METRICS));
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ORGANIC_METRICS) != null) {
            TweetOrganicMetrics.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ORGANIC_METRICS));
        }
    }

    public static Tweet fromJson(String jsonString) throws IOException {
        return (Tweet)JSON.getGson().fromJson(jsonString, Tweet.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_CREATED_AT);
        openapiFields.add(SERIALIZED_NAME_TEXT);
        openapiFields.add(SERIALIZED_NAME_AUTHOR_ID);
        openapiFields.add(SERIALIZED_NAME_IN_REPLY_TO_USER_ID);
        openapiFields.add(SERIALIZED_NAME_CONVERSATION_ID);
        openapiFields.add(SERIALIZED_NAME_REPLY_SETTINGS);
        openapiFields.add(SERIALIZED_NAME_REFERENCED_TWEETS);
        openapiFields.add(SERIALIZED_NAME_ATTACHMENTS);
        openapiFields.add(SERIALIZED_NAME_CONTEXT_ANNOTATIONS);
        openapiFields.add(SERIALIZED_NAME_WITHHELD);
        openapiFields.add(SERIALIZED_NAME_GEO);
        openapiFields.add(SERIALIZED_NAME_ENTITIES);
        openapiFields.add(SERIALIZED_NAME_PUBLIC_METRICS);
        openapiFields.add(SERIALIZED_NAME_POSSIBLY_SENSITIVE);
        openapiFields.add(SERIALIZED_NAME_LANG);
        openapiFields.add(SERIALIZED_NAME_SOURCE);
        openapiFields.add(SERIALIZED_NAME_NON_PUBLIC_METRICS);
        openapiFields.add(SERIALIZED_NAME_PROMOTED_METRICS);
        openapiFields.add(SERIALIZED_NAME_ORGANIC_METRICS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_TEXT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Tweet.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Tweet.class));
            return new TypeAdapter<Tweet>(){

                public void write(JsonWriter out, Tweet value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Tweet read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Tweet.validateJsonObject(jsonObj);
                    return (Tweet)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

