/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@ApiModel(description="Represent a Search Count Result")
public class SearchCount {
    public static final String SERIALIZED_NAME_END = "end";
    @SerializedName(value="end")
    private OffsetDateTime end;
    public static final String SERIALIZED_NAME_START = "start";
    @SerializedName(value="start")
    private OffsetDateTime start;
    public static final String SERIALIZED_NAME_TWEET_COUNT = "tweet_count";
    @SerializedName(value="tweet_count")
    private Integer tweetCount;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SearchCount end(OffsetDateTime end) {
        this.end = end;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The end time of the bucket")
    public OffsetDateTime getEnd() {
        return this.end;
    }

    public void setEnd(OffsetDateTime end) {
        this.end = end;
    }

    public SearchCount start(OffsetDateTime start) {
        this.start = start;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The start time of the bucket")
    public OffsetDateTime getStart() {
        return this.start;
    }

    public void setStart(OffsetDateTime start) {
        this.start = start;
    }

    public SearchCount tweetCount(Integer tweetCount) {
        this.tweetCount = tweetCount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The count for the bucket")
    public Integer getTweetCount() {
        return this.tweetCount;
    }

    public void setTweetCount(Integer tweetCount) {
        this.tweetCount = tweetCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchCount searchCount = (SearchCount)o;
        return Objects.equals(this.end, searchCount.end) && Objects.equals(this.start, searchCount.start) && Objects.equals(this.tweetCount, searchCount.tweetCount);
    }

    public int hashCode() {
        return Objects.hash(this.end, this.start, this.tweetCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchCount {\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    tweetCount: ").append(this.toIndentedString(this.tweetCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SearchCount is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SearchCount` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
    }

    public static SearchCount fromJson(String jsonString) throws IOException {
        return (SearchCount)JSON.getGson().fromJson(jsonString, SearchCount.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_END);
        openapiFields.add(SERIALIZED_NAME_START);
        openapiFields.add(SERIALIZED_NAME_TWEET_COUNT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_END);
        openapiRequiredFields.add(SERIALIZED_NAME_START);
        openapiRequiredFields.add(SERIALIZED_NAME_TWEET_COUNT);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SearchCount.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SearchCount.class));
            return new TypeAdapter<SearchCount>(){

                public void write(JsonWriter out, SearchCount value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SearchCount read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SearchCount.validateJsonObject(jsonObj);
                    return (SearchCount)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

