/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.AnimatedGif;
import com.twitter.clientlib.model.Photo;
import com.twitter.clientlib.model.Video;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Media {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    protected String type = this.getClass().getSimpleName();
    public static final String SERIALIZED_NAME_MEDIA_KEY = "media_key";
    @SerializedName(value="media_key")
    private String mediaKey;
    public static final String SERIALIZED_NAME_HEIGHT = "height";
    @SerializedName(value="height")
    private Integer height;
    public static final String SERIALIZED_NAME_WIDTH = "width";
    @SerializedName(value="width")
    private Integer width;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Media type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Media mediaKey(String mediaKey) {
        this.mediaKey = mediaKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Media Key identifier for this attachment.")
    public String getMediaKey() {
        return this.mediaKey;
    }

    public void setMediaKey(String mediaKey) {
        this.mediaKey = mediaKey;
    }

    public Media height(Integer height) {
        this.height = height;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The height of the media in pixels")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Media width(Integer width) {
        this.width = width;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The width of the media in pixels")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Media media = (Media)o;
        return Objects.equals(this.type, media.type) && Objects.equals(this.mediaKey, media.mediaKey) && Objects.equals(this.height, media.height) && Objects.equals(this.width, media.width);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.mediaKey, this.height, this.width);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Media {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    mediaKey: ").append(this.toIndentedString(this.mediaKey)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        String discriminatorValue;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in Media is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        switch (discriminatorValue = jsonObj.get(SERIALIZED_NAME_TYPE).getAsString()) {
            case "AnimatedGif": {
                AnimatedGif.validateJsonObject(jsonObj);
                break;
            }
            case "Photo": {
                Photo.validateJsonObject(jsonObj);
                break;
            }
            case "Video": {
                Video.validateJsonObject(jsonObj);
                break;
            }
            case "animated_gif": {
                AnimatedGif.validateJsonObject(jsonObj);
                break;
            }
            case "photo": {
                Photo.validateJsonObject(jsonObj);
                break;
            }
            case "video": {
                Video.validateJsonObject(jsonObj);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The value of the `type` field `%s` does not match any key defined in the discriminator's mapping.", discriminatorValue));
            }
        }
    }

    public static Media fromJson(String jsonString) throws IOException {
        return (Media)JSON.getGson().fromJson(jsonString, Media.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_MEDIA_KEY);
        openapiFields.add(SERIALIZED_NAME_HEIGHT);
        openapiFields.add(SERIALIZED_NAME_WIDTH);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }
}

