/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@ApiModel(description="Represent a boundary range (start and end index) for a recognized entity (for example a hashtag or a mention). `start` must be smaller than `end`.  The start index is inclusive, the end index is exclusive.")
public class EntityIndicesInclusiveExclusive {
    public static final String SERIALIZED_NAME_START = "start";
    @SerializedName(value="start")
    private Integer start;
    public static final String SERIALIZED_NAME_END = "end";
    @SerializedName(value="end")
    private Integer end;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public EntityIndicesInclusiveExclusive start(Integer start) {
        this.start = start;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="50", required=true, value="Index (zero-based) at which position this entity starts.  The index is inclusive.")
    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public EntityIndicesInclusiveExclusive end(Integer end) {
        this.end = end;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="61", required=true, value="Index (zero-based) at which position this entity ends.  The index is exclusive.")
    public Integer getEnd() {
        return this.end;
    }

    public void setEnd(Integer end) {
        this.end = end;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityIndicesInclusiveExclusive entityIndicesInclusiveExclusive = (EntityIndicesInclusiveExclusive)o;
        return Objects.equals(this.start, entityIndicesInclusiveExclusive.start) && Objects.equals(this.end, entityIndicesInclusiveExclusive.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityIndicesInclusiveExclusive {\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in EntityIndicesInclusiveExclusive is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `EntityIndicesInclusiveExclusive` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
    }

    public static EntityIndicesInclusiveExclusive fromJson(String jsonString) throws IOException {
        return (EntityIndicesInclusiveExclusive)JSON.getGson().fromJson(jsonString, EntityIndicesInclusiveExclusive.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_START);
        openapiFields.add(SERIALIZED_NAME_END);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_START);
        openapiRequiredFields.add(SERIALIZED_NAME_END);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!EntityIndicesInclusiveExclusive.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(EntityIndicesInclusiveExclusive.class));
            return new TypeAdapter<EntityIndicesInclusiveExclusive>(){

                public void write(JsonWriter out, EntityIndicesInclusiveExclusive value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public EntityIndicesInclusiveExclusive read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    EntityIndicesInclusiveExclusive.validateJsonObject(jsonObj);
                    return (EntityIndicesInclusiveExclusive)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

