/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.Problem;
import com.twitter.clientlib.model.Rule;
import com.twitter.clientlib.model.RulesResponseMetadata;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="A response from modifying user-specified stream filtering rules.")
public class AddOrDeleteRulesResponse {
    public static final String SERIALIZED_NAME_DATA = "data";
    @SerializedName(value="data")
    private List<Rule> data = null;
    public static final String SERIALIZED_NAME_META = "meta";
    @SerializedName(value="meta")
    private RulesResponseMetadata meta;
    public static final String SERIALIZED_NAME_ERRORS = "errors";
    @SerializedName(value="errors")
    private List<Problem> errors = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public AddOrDeleteRulesResponse data(List<Rule> data) {
        this.data = data;
        return this;
    }

    public AddOrDeleteRulesResponse addDataItem(Rule dataItem) {
        if (this.data == null) {
            this.data = new ArrayList<Rule>();
        }
        this.data.add(dataItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="All user-specified stream filtering rules that were created.")
    public List<Rule> getData() {
        return this.data;
    }

    public void setData(List<Rule> data) {
        this.data = data;
    }

    public AddOrDeleteRulesResponse meta(RulesResponseMetadata meta) {
        this.meta = meta;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public RulesResponseMetadata getMeta() {
        return this.meta;
    }

    public void setMeta(RulesResponseMetadata meta) {
        this.meta = meta;
    }

    public AddOrDeleteRulesResponse errors(List<Problem> errors) {
        this.errors = errors;
        return this;
    }

    public AddOrDeleteRulesResponse addErrorsItem(Problem errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<Problem>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<Problem> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Problem> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddOrDeleteRulesResponse addOrDeleteRulesResponse = (AddOrDeleteRulesResponse)o;
        return Objects.equals(this.data, addOrDeleteRulesResponse.data) && Objects.equals(this.meta, addOrDeleteRulesResponse.meta) && Objects.equals(this.errors, addOrDeleteRulesResponse.errors);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.meta, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddOrDeleteRulesResponse {\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayerrors;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in AddOrDeleteRulesResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `AddOrDeleteRulesResponse` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        JsonArray jsonArraydata = jsonObj.getAsJsonArray(SERIALIZED_NAME_DATA);
        if (jsonArraydata != null) {
            for (int i = 0; i < jsonArraydata.size(); ++i) {
                Rule.validateJsonObject(jsonArraydata.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_META) != null) {
            RulesResponseMetadata.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_META));
        }
        if ((jsonArrayerrors = jsonObj.getAsJsonArray(SERIALIZED_NAME_ERRORS)) != null) {
            for (int i = 0; i < jsonArrayerrors.size(); ++i) {
                Problem.validateJsonObject(jsonArrayerrors.get(i).getAsJsonObject());
            }
        }
    }

    public static AddOrDeleteRulesResponse fromJson(String jsonString) throws IOException {
        return (AddOrDeleteRulesResponse)JSON.getGson().fromJson(jsonString, AddOrDeleteRulesResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DATA);
        openapiFields.add(SERIALIZED_NAME_META);
        openapiFields.add(SERIALIZED_NAME_ERRORS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_META);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AddOrDeleteRulesResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AddOrDeleteRulesResponse.class));
            return new TypeAdapter<AddOrDeleteRulesResponse>(){

                public void write(JsonWriter out, AddOrDeleteRulesResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public AddOrDeleteRulesResponse read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    AddOrDeleteRulesResponse.validateJsonObject(jsonObj);
                    return (AddOrDeleteRulesResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

