/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.fastutilconcurrentwrapper.map;

import com.trivago.fastutilconcurrentwrapper.IntFloatMap;
import com.trivago.fastutilconcurrentwrapper.map.PrimitiveConcurrentMap;
import com.trivago.fastutilconcurrentwrapper.wrapper.PrimitiveFastutilIntFloatWrapper;
import it.unimi.dsi.fastutil.ints.Int2FloatFunction;
import java.util.concurrent.locks.Lock;
import java.util.function.BiFunction;

public class ConcurrentBusyWaitingIntFloatMap
extends PrimitiveConcurrentMap
implements IntFloatMap {
    private final IntFloatMap[] maps;
    private final float defaultValue;

    public ConcurrentBusyWaitingIntFloatMap(int numBuckets, int initialCapacity, float loadFactor, float defaultValue) {
        super(numBuckets);
        this.maps = new IntFloatMap[numBuckets];
        this.defaultValue = defaultValue;
        for (int i = 0; i < numBuckets; ++i) {
            this.maps[i] = new PrimitiveFastutilIntFloatWrapper(initialCapacity, loadFactor, defaultValue);
        }
    }

    @Override
    public int size() {
        return super.size(this.maps);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty(this.maps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(int key) {
        int bucket = this.getBucket(key);
        Lock readLock = this.locks[bucket].readLock();
        while (!readLock.tryLock()) {
        }
        try {
            boolean bl = this.maps[bucket].containsKey(key);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float get(int key) {
        int bucket = this.getBucket(key);
        Lock readLock = this.locks[bucket].readLock();
        while (!readLock.tryLock()) {
        }
        try {
            float f = this.maps[bucket].get(key);
            return f;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float put(int key, float value) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        while (!writeLock.tryLock()) {
        }
        try {
            float f = this.maps[bucket].put(key, value);
            return f;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public float getDefaultValue() {
        return this.defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float remove(int key) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        while (!writeLock.tryLock()) {
        }
        try {
            float f = this.maps[bucket].remove(key);
            return f;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(int key, float value) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        while (!writeLock.tryLock()) {
        }
        try {
            boolean bl = this.maps[bucket].remove(key, value);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float computeIfAbsent(int key, Int2FloatFunction mappingFunction) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        while (!writeLock.tryLock()) {
        }
        try {
            float f = this.maps[bucket].computeIfAbsent(key, mappingFunction);
            return f;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float computeIfPresent(int key, BiFunction<Integer, Float, Float> mappingFunction) {
        int bucket = this.getBucket(key);
        Lock writeLock = this.locks[bucket].writeLock();
        while (!writeLock.tryLock()) {
        }
        try {
            float f = this.maps[bucket].computeIfPresent(key, mappingFunction);
            return f;
        }
        finally {
            writeLock.unlock();
        }
    }
}

