/*
 * Decompiled with CFR 0.152.
 */
package com.tobedevoured.naether.util;

import com.tobedevoured.naether.NaetherException;
import com.tobedevoured.naether.maven.Project;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Parent;
import org.apache.maven.repository.internal.DefaultServiceLocator;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.impl.internal.SimpleLocalRepositoryManagerFactory;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.NoLocalRepositoryManagerException;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.util.artifact.DefaultArtifact;

public final class Notation {
    private static final Pattern NOTATION_PATTERN = Pattern.compile("^(.+?):(.+?):(.+?)(:(.+))?$");

    private Notation() {
    }

    public static String generate(org.apache.maven.model.Dependency dependency) {
        StringBuilder notation = new StringBuilder().append(dependency.getGroupId()).append(":").append(dependency.getArtifactId()).append(":");
        String classifier = dependency.getClassifier();
        if (classifier != null && "test-jar".equals(classifier)) {
            notation.append("jar:test-jar:");
        } else {
            String type = dependency.getType();
            if ("test-jar".equals(type)) {
                notation.append("jar:test-jar:");
            } else {
                notation.append(dependency.getType()).append(":");
            }
        }
        notation.append(dependency.getVersion());
        return notation.toString();
    }

    public static String generate(Project pom) {
        return pom.getGroupId() + ":" + pom.getArtifactId() + ":" + pom.getType() + ":" + pom.getVersion();
    }

    public static String generate(Dependency dependency) {
        return dependency.getArtifact().toString();
    }

    public static String generate(Map<String, String> notationMap) {
        StringBuilder notation = new StringBuilder();
        notation.append(notationMap.get("groupId")).append(":").append(notationMap.get("artifactId")).append(":");
        if (notationMap.get("type") != null) {
            notation.append(notationMap.get("type")).append(":");
        }
        notation.append(notationMap.get("version"));
        return notation.toString();
    }

    public static Map<String, String> parse(String notation) {
        Matcher matcher = NOTATION_PATTERN.matcher(notation);
        if (matcher.find()) {
            HashMap<String, String> notationMap = new HashMap<String, String>();
            int groupIdMatch = 1;
            notationMap.put("groupId", matcher.group(groupIdMatch));
            int artifactIdMatch = 2;
            notationMap.put("artifactId", matcher.group(artifactIdMatch));
            int groupingMatch = 4;
            if (matcher.group(groupingMatch) == null) {
                int versionMatch = 3;
                notationMap.put("version", matcher.group(versionMatch));
            } else {
                int typeMatch = 3;
                notationMap.put("type", matcher.group(typeMatch));
                int versionMatch = 5;
                notationMap.put("version", matcher.group(versionMatch));
            }
            return notationMap;
        }
        return null;
    }

    public static String generate(Artifact artifact) {
        StringBuilder notation = new StringBuilder().append(artifact.getGroupId()).append(":").append(artifact.getArtifactId()).append(":").append(artifact.getExtension()).append(":");
        if (artifact.getClassifier() != null && artifact.getClassifier().length() > 0) {
            notation.append(artifact.getClassifier()).append(":");
        }
        notation.append(artifact.getBaseVersion());
        return notation.toString();
    }

    public static List<String> getLocalPaths(String localRepoPath, List<String> notations) throws NaetherException {
        DefaultServiceLocator locator = new DefaultServiceLocator();
        SimpleLocalRepositoryManagerFactory factory = new SimpleLocalRepositoryManagerFactory();
        factory.initService((ServiceLocator)locator);
        LocalRepository localRepo = new LocalRepository(localRepoPath);
        LocalRepositoryManager manager = null;
        try {
            manager = factory.newInstance(localRepo);
        }
        catch (NoLocalRepositoryManagerException e) {
            throw new NaetherException("Failed to initial local repository manage", e);
        }
        ArrayList<String> localPaths = new ArrayList<String>();
        for (String notation : notations) {
            Dependency dependency = new Dependency((Artifact)new DefaultArtifact(notation), "compile");
            String path = localRepo.getBasedir().getAbsolutePath() + File.separator + manager.getPathForLocalArtifact(dependency.getArtifact());
            localPaths.add(path);
        }
        return localPaths;
    }

    public static String toUrlPath(Parent parent) throws IOException {
        String relativePath = "pom.xml";
        if (relativePath != parent.getRelativePath()) {
            relativePath = "".equals(parent.getRelativePath()) ? parent.getArtifactId() + "-" + parent.getVersion() + ".pom" : new File(parent.getRelativePath()).getCanonicalPath();
        }
        String urlPath = parent.getGroupId().replaceAll("\\.", "/").toLowerCase() + "/" + parent.getArtifactId().replaceAll("\\.", "/").toLowerCase() + "/" + parent.getVersion() + "/" + relativePath;
        return urlPath;
    }
}

