/*
 * Decompiled with CFR 0.152.
 */
package com.tobedevoured.naether.repo;

import com.tobedevoured.naether.aether.ValidSystemScopeDependencySelector;
import com.tobedevoured.naether.repo.BuildWorkspaceReader;
import com.tobedevoured.naether.repo.LogRepositoryListener;
import com.tobedevoured.naether.repo.LogTransferListener;
import com.tobedevoured.naether.repo.ManualWagonProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.repository.internal.DefaultServiceLocator;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositoryListener;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.CollectResult;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.collection.DependencySelector;
import org.sonatype.aether.connector.wagon.WagonProvider;
import org.sonatype.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.sonatype.aether.deployment.DeployRequest;
import org.sonatype.aether.deployment.DeploymentException;
import org.sonatype.aether.installation.InstallRequest;
import org.sonatype.aether.installation.InstallationException;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.WorkspaceReader;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.resolution.DependencyResult;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.util.graph.selector.AndDependencySelector;

public class RepositoryClient {
    private static Logger log = LoggerFactory.getLogger(RepositoryClient.class);
    private RepositorySystem repositorySystem = null;
    private MavenRepositorySystemSession systemSession = null;
    private String localRepoPath;

    public RepositoryClient(String localRepoPath) {
        this.localRepoPath = localRepoPath;
        this.newRepositorySystem();
    }

    public void setProperties(Map<String, String> properties) {
        HashMap<String, String> userProperties = this.systemSession.getUserProperties();
        if (userProperties == null) {
            userProperties = new HashMap<String, String>();
        }
        userProperties.putAll(properties);
        log.debug("Session userProperties: {}", userProperties);
        this.systemSession = (MavenRepositorySystemSession)this.systemSession.setUserProperties(userProperties);
    }

    public CollectResult collectDependencies(CollectRequest collectRequest) throws DependencyCollectionException {
        return this.repositorySystem.collectDependencies((RepositorySystemSession)this.systemSession, collectRequest);
    }

    public DependencyResult resolveDependencies(DependencyRequest dependencyRequest) throws DependencyResolutionException {
        return this.repositorySystem.resolveDependencies((RepositorySystemSession)this.systemSession, dependencyRequest);
    }

    public void deploy(DeployRequest deployRequest) throws DeploymentException {
        this.repositorySystem.deploy((RepositorySystemSession)this.systemSession, deployRequest);
    }

    public void install(InstallRequest installRequest) throws InstallationException {
        this.repositorySystem.install((RepositorySystemSession)this.systemSession, installRequest);
    }

    public ArtifactResult resolveArtifact(ArtifactRequest artifactRequest) throws ArtifactResolutionException {
        return this.repositorySystem.resolveArtifact((RepositorySystemSession)this.systemSession, artifactRequest);
    }

    public void setBuildWorkspaceReader(List<Artifact> artifacts) {
        BuildWorkspaceReader reader = new BuildWorkspaceReader();
        for (Artifact artifact : artifacts) {
            reader.addArtifact(artifact);
        }
        this.systemSession = (MavenRepositorySystemSession)this.systemSession.setWorkspaceReader((WorkspaceReader)reader);
    }

    public void newRepositorySystem() {
        DefaultServiceLocator locator = new DefaultServiceLocator();
        locator.setServices(WagonProvider.class, (Object[])new WagonProvider[]{new ManualWagonProvider()});
        locator.addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
        this.repositorySystem = (RepositorySystem)locator.getService(RepositorySystem.class);
        MavenRepositorySystemSession session = new MavenRepositorySystemSession();
        session = (MavenRepositorySystemSession)session.setDependencySelector((DependencySelector)new AndDependencySelector(new DependencySelector[]{session.getDependencySelector(), new ValidSystemScopeDependencySelector()}));
        session = (MavenRepositorySystemSession)session.setTransferListener((TransferListener)new LogTransferListener());
        session = (MavenRepositorySystemSession)session.setRepositoryListener((RepositoryListener)new LogRepositoryListener());
        session = (MavenRepositorySystemSession)session.setIgnoreMissingArtifactDescriptor(false);
        LocalRepository localRepo = new LocalRepository(this.localRepoPath);
        session.setLocalRepositoryManager(this.repositorySystem.newLocalRepositoryManager(localRepo));
        this.systemSession = session;
    }

    public RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    public MavenRepositorySystemSession getSystemSession() {
        return this.systemSession;
    }
}

