/*
 * Decompiled with CFR 0.152.
 */
package com.tobedevoured.naether.repo;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.transfer.AbstractTransferListener;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferResource;

public class LogTransferListener
extends AbstractTransferListener {
    private static final int INITAL_CAPACITY = 64;
    private static final int KB = 1024;
    private Logger log = LoggerFactory.getLogger((String)"NaetherTransfer");
    private Map<TransferResource, Long> downloads = new ConcurrentHashMap<TransferResource, Long>();
    private int lastLength;

    public void transferInitiated(TransferEvent event) {
        String message = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
        this.log.info(message + ": " + event.getResource().getRepositoryUrl() + event.getResource().getResourceName());
    }

    public void transferProgressed(TransferEvent event) {
        if (this.log.isDebugEnabled()) {
            TransferResource resource = event.getResource();
            this.downloads.put(resource, event.getTransferredBytes());
            StringBuilder buffer = new StringBuilder(64);
            for (Map.Entry<TransferResource, Long> entry : this.downloads.entrySet()) {
                long total = entry.getKey().getContentLength();
                long complete = entry.getValue();
                buffer.append(this.getStatus(complete, total)).append("  ");
            }
            int pad = this.lastLength - buffer.length();
            this.lastLength = buffer.length();
            this.pad(buffer, pad);
            this.log.debug(buffer.toString());
        }
    }

    private String getStatus(long complete, long total) {
        if (total >= 1024L) {
            return this.toKB(complete) + "/" + this.toKB(total) + " KB ";
        }
        if (total >= 0L) {
            return complete + "/" + total + " B ";
        }
        if (complete >= 1024L) {
            return this.toKB(complete) + " KB ";
        }
        return complete + " B ";
    }

    private void pad(StringBuilder buffer, int spaces) {
        int n;
        String block = "                                        ";
        for (int spacesLeft = spaces; spacesLeft > 0; spacesLeft -= n) {
            n = Math.min(spaces, block.length());
            buffer.append(block, 0, n);
        }
    }

    public void transferSucceeded(TransferEvent event) {
        this.transferCompleted(event);
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        if (contentLength >= 0L) {
            String type = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
            String len = contentLength >= 1024L ? this.toKB(contentLength) + " KB" : contentLength + " B";
            String throughput = "";
            long duration = System.currentTimeMillis() - resource.getTransferStartTime();
            if (duration > 0L) {
                DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                double kbPerSec = (double)(contentLength / 1024L) / ((double)duration / 1000.0);
                throughput = " at " + format.format(kbPerSec) + " KB/sec";
            }
            this.log.debug(type + ": " + resource.getRepositoryUrl() + resource.getResourceName() + " (" + len + throughput + ")");
        }
    }

    public void transferFailed(TransferEvent event) {
        this.transferCompleted(event);
        this.log.debug("Transfer Failed from repo {} for {}", (Object)event.getResource().getRepositoryUrl(), (Object)event.getResource().getResourceName());
        this.log.debug("Transfer Failed Exception", (Throwable)event.getException());
    }

    private void transferCompleted(TransferEvent event) {
        this.downloads.remove(event.getResource());
        StringBuilder buffer = new StringBuilder(64);
        this.pad(buffer, this.lastLength);
        this.log.debug(buffer.toString());
    }

    public void transferCorrupted(TransferEvent event) {
        this.log.error("Transfer Corrupted", (Throwable)event.getException());
    }

    protected long toKB(long bytes) {
        return (bytes + 1023L) / 1024L;
    }
}

