/*
 * Decompiled with CFR 0.152.
 */
package com.tobedevoured.naether.maven;

import com.tobedevoured.naether.repo.RepositoryClient;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.impl.RemoteRepositoryManager;
import org.sonatype.aether.impl.internal.DefaultRemoteRepositoryManager;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.util.artifact.DefaultArtifact;

public class NaetherModelResolver
implements ModelResolver {
    private List<RemoteRepository> repositories;
    private Set<String> repositoryIds;
    private RepositorySystem system;
    private RepositorySystemSession session;
    private RemoteRepositoryManager remoteRepositoryManager;

    public NaetherModelResolver(RepositoryClient repositoryClient, Collection<RemoteRepository> remoteRepositories) {
        this.system = repositoryClient.getRepositorySystem();
        this.session = repositoryClient.getSystemSession();
        this.repositories = remoteRepositories != null ? new ArrayList<RemoteRepository>(remoteRepositories) : new ArrayList<RemoteRepository>();
        this.repositoryIds = new HashSet<String>();
        this.remoteRepositoryManager = new DefaultRemoteRepositoryManager();
    }

    public NaetherModelResolver(NaetherModelResolver original) {
        this.system = original.system;
        this.session = original.session;
        this.repositories = new ArrayList<RemoteRepository>(original.repositories);
        this.repositoryIds = new HashSet<String>(original.repositoryIds);
        this.remoteRepositoryManager = original.remoteRepositoryManager;
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
        DefaultArtifact pomArtifact = new DefaultArtifact(groupId, artifactId, "", "pom", version);
        try {
            ArtifactRequest request = new ArtifactRequest((Artifact)pomArtifact, this.repositories, null);
            pomArtifact = this.system.resolveArtifact(this.session, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new UnresolvableModelException(e.getMessage(), groupId, artifactId, version, (Throwable)e);
        }
        File pomFile = pomArtifact.getFile();
        return new FileModelSource(pomFile);
    }

    public void addRepository(Repository repository) throws InvalidRepositoryException {
        if (!this.repositoryIds.add(repository.getId())) {
            return;
        }
        List<RemoteRepository> newRepositories = Collections.singletonList(ArtifactDescriptorUtils.toRemoteRepository((Repository)repository));
        this.repositories = this.remoteRepositoryManager.aggregateRepositories(this.session, this.repositories, newRepositories, true);
    }

    public ModelResolver newCopy() {
        return new NaetherModelResolver(this);
    }
}

