/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.trace;

import com.qq.tars.support.trace.TraceManager;
import io.opentracing.Scope;
import io.opentracing.Tracer;
import java.io.Closeable;
import java.io.IOException;

public class TraceContext
implements Closeable {
    private final ThreadLocal<Tracer> currentTracer = new ThreadLocal();
    private static final TraceContext instance = new TraceContext();

    private TraceContext() {
    }

    public static TraceContext getInstance() {
        return instance;
    }

    public TraceContext initCurrentTrace(String servantName) {
        Tracer tracer = null;
        if (servantName == null || servantName.isEmpty()) {
            return instance;
        }
        tracer = TraceManager.getInstance().getCurrentTracer(servantName);
        this.currentTracer.set(tracer);
        return instance;
    }

    public void clear() {
        this.currentTracer.remove();
    }

    public Tracer getCurrentTracer() {
        return this.currentTracer.get();
    }

    public void tag(String key, String value) {
        Scope scope;
        Tracer tracer = this.currentTracer.get();
        if (tracer != null && (scope = tracer.scopeManager().active()) != null) {
            scope.span().setTag(key, value);
        }
    }

    public void log(String event, long timestamp) {
        Scope scope;
        Tracer tracer = this.currentTracer.get();
        if (tracer != null && (scope = tracer.scopeManager().active()) != null) {
            scope.span().log(timestamp, event);
        }
    }

    public void log(String event) {
        Scope scope;
        Tracer tracer = this.currentTracer.get();
        if (tracer != null && (scope = tracer.scopeManager().active()) != null) {
            scope.span().log(event);
        }
    }

    @Override
    public void close() throws IOException {
        this.clear();
    }
}

