/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.om;

import com.qq.tars.client.Communicator;
import com.qq.tars.client.CommunicatorFactory;
import com.qq.tars.common.ClientVersion;
import com.qq.tars.server.config.ConfigurationManager;
import com.qq.tars.support.config.ConfigHelper;
import com.qq.tars.support.node.NodeHelper;
import com.qq.tars.support.notify.NotifyHelper;
import com.qq.tars.support.om.ScheduledServiceMngr;
import com.qq.tars.support.om.ServerStatHelper;
import com.qq.tars.support.property.CommonPropertyPolicy;
import com.qq.tars.support.property.JvmPropertyPolicy;
import com.qq.tars.support.property.PropertyReportHelper;
import com.qq.tars.support.trace.TarsTraceZipkinConfiguration;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;

public class OmServiceMngr {
    private static final OmServiceMngr Instance = new OmServiceMngr();

    public static OmServiceMngr getInstance() {
        return Instance;
    }

    public void initAndStartOmService() {
        Communicator communicator = CommunicatorFactory.getInstance().getCommunicator();
        String app = ConfigurationManager.getInstance().getServerConfig().getApplication();
        String serverName = ConfigurationManager.getInstance().getServerConfig().getServerName();
        String basePath = ConfigurationManager.getInstance().getServerConfig().getBasePath();
        String modualName = ConfigurationManager.getInstance().getServerConfig().getCommunicatorConfig().getModuleName();
        ConfigHelper.getInstance().setConfigInfo(communicator, app, serverName, basePath);
        NodeHelper.getInstance().setNodeInfo(communicator, app, serverName);
        NotifyHelper.getInstance().setNotifyInfo(communicator, app, serverName);
        PropertyReportHelper.getInstance().init(communicator, modualName);
        NodeHelper.getInstance().reportVersion(ClientVersion.getVersion());
        CommonPropertyPolicy.Avg avgPolicy = new CommonPropertyPolicy.Avg();
        CommonPropertyPolicy.Max maxPolicy = new CommonPropertyPolicy.Max();
        PropertyReportHelper.getInstance().createPropertyReporter("req.queue.waitingtime", avgPolicy, maxPolicy);
        PropertyReportHelper.getInstance().createPropertyReporter("jvm.memory.heap.used", new JvmPropertyPolicy.MemoryHeapUsedAvg());
        PropertyReportHelper.getInstance().createPropertyReporter("jvm.memory.heap.committed", new JvmPropertyPolicy.MemoryHeapCommittedAvg());
        PropertyReportHelper.getInstance().createPropertyReporter("jvm.memory.heap.max", new JvmPropertyPolicy.MemoryHeapMaxAvg());
        PropertyReportHelper.getInstance().createPropertyReporter("jvm.thread.num", new JvmPropertyPolicy.ThreadNumAvg());
        for (GarbageCollectorMXBean gcMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            PropertyReportHelper.getInstance().createPropertyReporter("jvm.gc.num." + gcMXBean.getName(), new JvmPropertyPolicy.GCNumCount(gcMXBean.getName()));
            PropertyReportHelper.getInstance().createPropertyReporter("jvm.gc.time." + gcMXBean.getName(), new JvmPropertyPolicy.GCTimeSum(gcMXBean.getName()));
        }
        ServerStatHelper.getInstance().init(communicator);
        TarsTraceZipkinConfiguration.getInstance().init();
        ScheduledServiceMngr.getInstance().start();
    }

    public void reportWaitingTimeProperty(int value) {
        PropertyReportHelper.getInstance().reportPropertyValue("req.queue.waitingtime", value);
    }
}

