/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.notify;

import com.qq.tars.client.Communicator;
import com.qq.tars.server.config.ConfigurationManager;
import com.qq.tars.support.log.LoggerFactory;
import com.qq.tars.support.notify.prx.NOTIFYLEVEL;
import com.qq.tars.support.notify.prx.NotifyPrx;
import org.slf4j.Logger;

public class NotifyHelper {
    private static final Logger omLogger = LoggerFactory.getOmLogger();
    private static final NotifyHelper Instance = new NotifyHelper();
    private Communicator communicator;
    private String app;
    private String server;

    public static NotifyHelper getInstance() {
        return Instance;
    }

    public int setNotifyInfo(Communicator comm, String app, String server) {
        this.communicator = comm;
        this.app = app;
        this.server = server;
        return 0;
    }

    private void notify(NOTIFYLEVEL level, String message) {
        try {
            if (this.communicator == null) {
                return;
            }
            NotifyPrx notifyPrx = this.communicator.stringToProxy(NotifyPrx.class, ConfigurationManager.getInstance().getServerConfig().getNotify());
            notifyPrx.async_notifyServer(null, this.app + "." + this.server, level.value(), message);
        }
        catch (Exception e) {
            omLogger.error("RemoteNotify|notify error", (Throwable)e);
        }
    }

    public void notifyNormal(String info) {
        this.notify(NOTIFYLEVEL.NOTIFYNORMAL, info);
    }

    public void notifyWarn(String info) {
        this.notify(NOTIFYLEVEL.NOTIFYWARN, info);
    }

    public void notifyError(String info) {
        this.notify(NOTIFYLEVEL.NOTIFYERROR, info);
    }

    public void syncReport(String result) {
        this.report(result, true);
    }

    public void asyncReport(String result) {
        this.report(result, false);
    }

    private void report(String result, boolean sync) {
        try {
            if (this.communicator == null) {
                return;
            }
            NotifyPrx notifyPrx = this.communicator.stringToProxy(NotifyPrx.class, ConfigurationManager.getInstance().getServerConfig().getNotify());
            if (sync) {
                notifyPrx.reportServer(this.app + "." + this.server, Thread.currentThread().getId() + "", result);
            } else {
                notifyPrx.async_reportServer(null, this.app + "." + this.server, Thread.currentThread().getId() + "", result);
            }
        }
        catch (Exception e) {
            omLogger.error("RemoteNotify|report error", (Throwable)e);
        }
    }
}

