/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.config;

import com.qq.tars.client.Communicator;
import com.qq.tars.common.support.Holder;
import com.qq.tars.common.util.FileUtil;
import com.qq.tars.common.util.StringUtils;
import com.qq.tars.rpc.exc.TarsException;
import com.qq.tars.server.config.ConfigurationManager;
import com.qq.tars.support.config.UpdateConfigCallback;
import com.qq.tars.support.config.prx.ConfigInfo;
import com.qq.tars.support.config.prx.ConfigPrx;
import com.qq.tars.support.log.LoggerFactory;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class ConfigHelper {
    private static final Logger omLogger = LoggerFactory.getOmLogger();
    private static final ConfigHelper Instance = new ConfigHelper();
    private Communicator comm;
    private String app;
    private String serverName;
    private String basePath;
    private int maxBakNum;
    private Map<String, UpdateConfigCallback> updateCallbackMap = new ConcurrentHashMap<String, UpdateConfigCallback>();

    private ConfigHelper() {
    }

    public static ConfigHelper getInstance() {
        return Instance;
    }

    public int setConfigInfo(Communicator comm, String app, String serverName, String basePath, int maxBakNum) {
        this.comm = comm;
        this.app = app;
        this.serverName = serverName;
        this.basePath = basePath + "/conf/";
        this.maxBakNum = maxBakNum;
        return 0;
    }

    public int setConfigInfo(Communicator comm, String app, String serverName, String basePath) {
        return this.setConfigInfo(comm, app, serverName, basePath, 5);
    }

    public boolean registerUpdateCallback(String configFileName, UpdateConfigCallback callback) {
        if (StringUtils.isEmpty(configFileName) || callback == null) {
            return false;
        }
        this.updateCallbackMap.put(configFileName, callback);
        return true;
    }

    private synchronized boolean loadConfig(String fileName, boolean appConfigOnly) {
        try {
            String fullFileName = this.getConfFilePath(fileName);
            String newFile = this.getRemoteFile(fileName, appConfigOnly);
            if (new File(fullFileName).exists() && !FileUtil.readFileToString(fullFileName).equals(FileUtil.readFileToString(newFile))) {
                for (int i = this.maxBakNum - 1; i >= 1; --i) {
                    String bakFileI = this.index2file(fullFileName, i);
                    if (!new File(bakFileI).canRead()) continue;
                    this.localRename(bakFileI, this.index2file(fullFileName, i + 1));
                }
                if (new File(fullFileName).canRead()) {
                    this.localRename(fullFileName, this.index2file(fullFileName, 1));
                }
            }
            this.localRename(newFile, fullFileName);
        }
        catch (TarsException e) {
            omLogger.error("Config|load config failed: " + fileName, (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            omLogger.error("Config|load config failed: " + fileName, (Throwable)e);
            throw new TarsException("Config|load config failed: " + fileName, e);
        }
        return true;
    }

    public boolean loadConfig(String fileName) {
        UpdateConfigCallback callback;
        if (StringUtils.isEmpty(fileName)) {
            return false;
        }
        boolean result = this.loadConfig(fileName, false);
        if (result && (callback = this.updateCallbackMap.get(fileName)) != null) {
            result = callback.update(fileName);
        }
        return result;
    }

    private String getRemoteFile(String fileName, boolean appConfigOnly) {
        Holder<String> config = new Holder<String>();
        ConfigPrx configPrx = this.comm.stringToProxy(ConfigPrx.class, ConfigurationManager.getInstance().getServerConfig().getConfig());
        ConfigInfo configInfo = new ConfigInfo(this.app, appConfigOnly ? "" : this.serverName, fileName, appConfigOnly, ConfigurationManager.getInstance().getServerConfig().getLocalIP(), ConfigurationManager.getInstance().getServerConfig().getCommunicatorConfig().getSetDivision());
        int ret = configPrx.loadConfigByInfo(configInfo, config);
        String stream = (String)config.value;
        if (ret != 0 || stream == null || stream.length() == 0) {
            throw new TarsException("Config|config file is empty: " + fileName);
        }
        String newFile = this.getConfFilePath(fileName) + "." + System.currentTimeMillis() / 100L;
        FileUtil.writeStringToFile(newFile, stream);
        return newFile;
    }

    private String getConfFilePath(String fileName) {
        return this.basePath + fileName;
    }

    private String index2file(String fullFileName, int index) {
        return fullFileName + "." + index + ".bak";
    }

    private void localRename(String oldFile, String newFile) {
        boolean ok;
        File srcFile = new File(oldFile);
        File destFile = new File(newFile);
        boolean bl = ok = (!destFile.exists() || destFile.delete()) && srcFile.renameTo(destFile);
        if (!ok) {
            throw new TarsException("Config|rename file error: " + newFile);
        }
    }
}

