/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.server.core;

import com.qq.tars.rpc.protocol.tars.TarsServantRequest;
import com.qq.tars.rpc.protocol.tars.TarsServantResponse;
import com.qq.tars.server.core.AppContext;
import com.qq.tars.server.core.AppContextManager;
import com.qq.tars.server.core.Context;
import com.qq.tars.server.core.ContextManager;
import com.qq.tars.server.core.ServantHomeSkeleton;
import com.qq.tars.server.core.TarsServantProcessor;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncContext {
    public static final String PORTAL_CAP_ASYNC_CONTEXT_ATTRIBUTE = "internal.asynccontext";
    private Context<TarsServantRequest, TarsServantResponse> context = null;
    private static final Logger flowLogger = LoggerFactory.getLogger((String)"tarsserver");

    public static AsyncContext startAsync() throws IOException {
        Context<TarsServantRequest, TarsServantResponse> context = ContextManager.getContext();
        AsyncContext aContext = new AsyncContext(context);
        context.response().asyncCallStart();
        context.setAttribute(PORTAL_CAP_ASYNC_CONTEXT_ATTRIBUTE, aContext);
        return aContext;
    }

    private AsyncContext(Context<TarsServantRequest, TarsServantResponse> context) {
        this.context = context;
    }

    private ServantHomeSkeleton getCapHomeSkeleton() {
        AppContext appContext = AppContextManager.getInstance().getAppContext();
        return appContext.getCapHomeSkeleton(this.context.request().getServantName());
    }

    public <T> T getAttribute(String name) {
        return this.context.getAttribute(name);
    }

    public <T> T getAttribute(String name, T defaultValue) {
        return this.context.getAttribute(name, defaultValue);
    }

    public <T> void setAttribute(String name, T value) {
        this.context.setAttribute(name, value);
    }

    public Context getContext() {
        return this.context;
    }

    public void writeException(Throwable ex) throws IOException {
        TarsServantResponse response = this.context.response();
        response.setRet(-99);
        response.setCause(ex);
        response.setResult(null);
        response.asyncCallEnd();
        this.getCapHomeSkeleton().postInvokeCapHomeSkeleton();
        Long startTime = (Long)this.context.getAttribute("internal.startTime");
        TarsServantProcessor.printServiceFlowLog(flowLogger, this.context.request(), response.getRet(), System.currentTimeMillis() - startTime, ex.toString());
    }

    public void writeResult(Object result) throws IOException {
        TarsServantResponse response = this.context.response();
        response.setRet(0);
        response.setCause(null);
        response.setResult(result);
        response.asyncCallEnd();
        this.getCapHomeSkeleton().postInvokeCapHomeSkeleton();
        Long startTime = (Long)this.context.getAttribute("internal.startTime");
        TarsServantProcessor.printServiceFlowLog(flowLogger, this.context.request(), response.getRet(), System.currentTimeMillis() - startTime, "");
    }
}

