/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.server.config;

import com.qq.tars.client.CommunicatorConfig;
import com.qq.tars.common.support.Endpoint;
import com.qq.tars.common.util.Config;
import com.qq.tars.server.config.ServantAdapterConfig;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;

public class ServerConfig {
    private String application;
    private String serverName;
    private Endpoint local;
    private String node;
    private String basePath;
    private String config;
    private String notify;
    private String log;
    private String logPath;
    private String logLevel;
    private int logRate = 5;
    private String dataPath;
    private String localIP;
    private float sampleRate = 0.0f;
    private String sampleType;
    private String sampleAddress;
    private String sampleEncoding;
    private int sessionTimeOut = 120000;
    private int sessionCheckInterval = 60000;
    private boolean tcpNoDelay = false;
    private int udpBufferSize = 4096;
    private String charsetName = "UTF-8";
    private LinkedHashMap<String, ServantAdapterConfig> servantAdapterConfMap;
    private CommunicatorConfig communicatorConfig;

    public ServerConfig load(Config conf) {
        this.application = conf.get("/tars/application/server<app>", "UNKNOWN");
        this.serverName = conf.get("/tars/application/server<server>", null);
        String localStr = conf.get("/tars/application/server<local>");
        this.local = localStr == null || localStr.length() <= 0 ? null : Endpoint.parseString(localStr);
        this.node = conf.get("/tars/application/server<node>");
        this.basePath = conf.get("/tars/application/server<basepath>");
        this.dataPath = conf.get("/tars/application/server<datapath>");
        this.charsetName = conf.get("/tars/application/server<charsetname>", "UTF-8");
        this.config = conf.get("/tars/application/server<config>");
        this.notify = conf.get("/tars/application/server<notify>");
        this.log = conf.get("/tars/application/server<log>");
        this.logPath = conf.get("/tars/application/server<logpath>", null);
        this.logLevel = conf.get("/tars/application/server<loglevel>");
        this.logRate = conf.getInt("/tars/application/server<lograte>", 5);
        this.localIP = conf.get("/tars/application/server<localip>");
        this.sampleRate = Float.parseFloat(conf.get("/tars/application/server<samplerate>", "0"));
        this.sampleType = conf.get("/tars/application/server<sampletype>");
        this.sampleAddress = conf.get("/tars/application/server<sampleaddress>");
        this.sampleEncoding = conf.get("/tars/application/server<sampleencoding>", "json");
        this.sessionTimeOut = conf.getInt("/tars/application/server<sessiontimeout>", 120000);
        this.sessionCheckInterval = conf.getInt("/tars/application/server<sessioncheckinterval>", 60000);
        this.udpBufferSize = conf.getInt("/tars/application/server<udpbuffersize>", 4096);
        this.tcpNoDelay = conf.getBool("/tars/application/server<tcpnodelay>", false);
        this.servantAdapterConfMap = new LinkedHashMap();
        List<String> adapterNameList = conf.getSubTags("/tars/application/server");
        if (adapterNameList != null) {
            for (String adapterName : adapterNameList) {
                ServantAdapterConfig config = new ServantAdapterConfig();
                config.load(conf, adapterName);
                this.servantAdapterConfMap.put(config.getServant(), config);
            }
        }
        ServantAdapterConfig adminServantAdapterConfig = new ServantAdapterConfig();
        adminServantAdapterConfig.setEndpoint(this.local);
        adminServantAdapterConfig.setServant(String.format("%s.%s.%s", this.application, this.serverName, "AdminObj"));
        this.servantAdapterConfMap.put("AdminObj", adminServantAdapterConfig);
        if (this.application != null && this.serverName != null && this.logPath != null) {
            this.logPath = this.logPath + File.separator + this.application + File.separator + this.serverName;
        }
        this.communicatorConfig = new CommunicatorConfig().load(conf);
        if (this.logPath != null) {
            this.communicatorConfig.setLogPath(this.logPath);
        }
        this.communicatorConfig.setLogLevel(this.logLevel);
        this.communicatorConfig.setDataPath(this.dataPath);
        return this;
    }

    public String getApplication() {
        return this.application;
    }

    public ServerConfig setApplication(String application) {
        this.application = application;
        return this;
    }

    public String getServerName() {
        return this.serverName;
    }

    public ServerConfig setServerName(String serverName) {
        this.serverName = serverName;
        return this;
    }

    public Endpoint getLocal() {
        return this.local;
    }

    public ServerConfig setLocal(Endpoint local) {
        this.local = local;
        return this;
    }

    public String getNode() {
        return this.node;
    }

    public ServerConfig setNode(String node) {
        this.node = node;
        return this;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ServerConfig setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public String getConfig() {
        return this.config;
    }

    public ServerConfig setConfig(String config) {
        this.config = config;
        return this;
    }

    public String getNotify() {
        return this.notify;
    }

    public ServerConfig setNotify(String notify) {
        this.notify = notify;
        return this;
    }

    public String getLog() {
        return this.log;
    }

    public ServerConfig setLog(String log) {
        this.log = log;
        return this;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public ServerConfig setLogPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    public int getLogRate() {
        return this.logRate;
    }

    public ServerConfig setLogRate(int logRate) {
        this.logRate = logRate;
        return this;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public ServerConfig setLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public String getLocalIP() {
        return this.localIP;
    }

    public ServerConfig setLocalIP(String localIP) {
        this.localIP = localIP;
        return this;
    }

    public LinkedHashMap<String, ServantAdapterConfig> getServantAdapterConfMap() {
        return this.servantAdapterConfMap;
    }

    public ServerConfig setServantAdapterConfMap(LinkedHashMap<String, ServantAdapterConfig> servantAdapterConfMap) {
        this.servantAdapterConfMap = servantAdapterConfMap;
        return this;
    }

    public CommunicatorConfig getCommunicatorConfig() {
        return this.communicatorConfig;
    }

    public ServerConfig setCommunicatorConfig(CommunicatorConfig communicatorConfig) {
        this.communicatorConfig = communicatorConfig;
        return this;
    }

    public String getDataPath() {
        return this.dataPath;
    }

    public ServerConfig setDataPath(String dataPath) {
        this.dataPath = dataPath;
        return this;
    }

    public int getSessionTimeOut() {
        return this.sessionTimeOut;
    }

    public ServerConfig setSessionTimeOut(int sessionTimeOut) {
        this.sessionTimeOut = sessionTimeOut;
        return this;
    }

    public int getSessionCheckInterval() {
        return this.sessionCheckInterval;
    }

    public ServerConfig setSessionCheckInterval(int sessionCheckInterval) {
        this.sessionCheckInterval = sessionCheckInterval;
        return this;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public ServerConfig setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    public int getUdpBufferSize() {
        return this.udpBufferSize;
    }

    public ServerConfig setUdpBufferSize(int udpBufferSize) {
        this.udpBufferSize = udpBufferSize;
        return this;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public ServerConfig setCharsetName(String charsetName) {
        this.charsetName = charsetName;
        return this;
    }

    public int getLocalPort() {
        return this.local.port();
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(float sampleRate) {
        this.sampleRate = sampleRate;
    }

    public String getSampleType() {
        return this.sampleType;
    }

    public void setSampleType(String sampleType) {
        this.sampleType = sampleType;
    }

    public String getSampleAddress() {
        return this.sampleAddress;
    }

    public void setSampleAddress(String sampleAddress) {
        this.sampleAddress = sampleAddress;
    }

    public String getSampleEncoding() {
        return this.sampleEncoding;
    }

    public void setSampleEncoding(String sampleEncoding) {
        this.sampleEncoding = sampleEncoding;
    }
}

